///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.logcast;



import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import lava.io.IoCloser;
import lava.io.LineSeparatorFilter;
import lava.thread.ThreadToolbox;
import lava.util.FifoQueue;



class Connection
	extends Thread
{



	private final Socket socket;



	private final PrintWriter out;



	Connection (Socket socket) throws IOException
	{
		this . socket = socket;
		out = new PrintWriter (socket . getOutputStream ());
		start ();
	}



	private final FifoQueue queue = new FifoQueue ();



	public void run ()
	{
		while (true)
		{
			String line;
			synchronized (this)
			{
				if (queue . isEmpty ())
				{
					if (skipping >= 0)
					{
						queue . addElement ("### BUFFER FULL -- SKIPPED " + skipping + " LINES ###");
						skipping = -1;
					}
					else if (more)
					{
						ThreadToolbox.wait (this);
						continue;
					}
					else
						break;
				}
				if (queue . size () > Options.buffer_size)
					skipping = 0;
				line = (String) queue . nextElement ();
			}
			out . print (line + LineSeparatorFilter.DOS_LINE_SEPARATOR);
			out . flush ();
			if (out . checkError ())
				shutDown ();
		}
		IoCloser.close (out);
		IoCloser.close (socket);
	}



	private int skipping = -1;



	private boolean more = true;



	synchronized boolean sendLine (String line)
	{
		if (skipping < 0 && more)
		{
			queue . addElement (line);
			notifyAll ();
		}
		else
			++ skipping;
		return more;
	}



	synchronized void shutDown ()
	{
		more = false;
		notifyAll ();
	}



}



