///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.logcast;



import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import lava.io.FileFormatException;
import lava.io.HashCommentStripperReader;
import lava.io.IoCloser;
import lava.string.StringToolbox;
import lava.string.WildcardExpression;
import lava.thread.ThreadToolbox;



class ConnectionManager
	extends Thread
{



	private final ServerSocket ss;



	ConnectionManager () throws IOException
	{
		ss = new ServerSocket (Options.bind_port, Options.backlog, Options.bind_address);
		start ();
	}



	public void run ()
	{
		try
		{
			while (connections != null)
			{
				synchronized (this)
				{
					if (connections . size () >= Options.max_connections)
					{
						ThreadToolbox.wait (this);
						continue;
					}
				}
				try
				{
					Socket sock_in = ss . accept ();
					if (accessAllowed (sock_in . getInetAddress () . getHostAddress ()))
						addSocket (new Connection (sock_in));
					else
						sock_in . close ();
				}
				catch (SocketException e)
				{
				}
				catch (IOException e)
				{
					System.err . println (e);
				}
			}
			IoCloser.close (ss);
		}
		catch (Exception e)
		{
		}
	}



	private Vector connections = new Vector ();



	private synchronized void addSocket (Connection connection)
	{
		if (connections != null)
			connections . addElement (connection);
		else
			connection . shutDown ();
	}



	synchronized void sendLine (String line)
	{
		int count = connections . size ();
		int i = 0;
		while (i < count)
		{
			Connection c = (Connection) connections . elementAt (i);
			if (! c . sendLine (line))
			{
				connections . removeElementAt (i);
				-- count;
				notifyAll ();
			}
			else
				++ i;
		}
	}



	synchronized void shutDown ()
	{
		Enumeration enum = connections . elements ();
		connections = null;
		while (enum . hasMoreElements ())
			((Connection) enum . nextElement ()) . shutDown ();
		IoCloser.close (ss);
		notifyAll ();
	}



	private boolean accessAllowed (String ipaddress)
	{
		BufferedReader in = null;
		try
		{
			in = new BufferedReader
			(
				new HashCommentStripperReader
				(
					new FileReader (Options.access_rules)
				)
			);
			boolean allowed = false;
			String line;
		loop:
			while (true)
			{
				line = in . readLine ();
				if (line == null)
					return allowed;
				String[] parts = StringToolbox.splitString (line, " \t");
				switch (parts . length)
				{
				case 0:
					continue;
				case 2:
					break;
				default:
					throw new FileFormatException ("incorrect number of fields: " + parts . length);
				}
				boolean is_allow_line;
				if (parts [0] . equals ("allow"))
					is_allow_line = true;
				else if (parts [0] . equals ("deny"))
					is_allow_line = false;
				else
					throw new FileFormatException ("unknown control directive: " + parts [0]);
				if (new WildcardExpression (parts [1]) . accept (ipaddress))
					allowed = is_allow_line;
			}
		}
		catch (IOException e)
		{
			System.err . println (e);
		}
		finally
		{
			IoCloser.close (in);
		}
		return false;
	}



}



