///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.logcast;



import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import lava.io.IoCloser;
import lava.io.IoToolbox;



public class Main
{



	public static void main (String[] args) throws IOException
	{
		if (args . length != 1)
		{
			IoToolbox.printLines
			(
				new String[]
				{
					"logcast, by Charlton Rose",
					"Copyright (c) 2000 Sharkysoft (sharkysoft.com).  All rights reserved.",
					"usage: java -jar logcast.jar <settings_file>"
				}
			);
			return;
		}
		Options.initialize (args [0]);
		ConnectionManager cm = new ConnectionManager ();
		BufferedReader in = new BufferedReader
		(
			new InputStreamReader
			(
				System.in
			)
		);
		try
		{
			while (true)
			{
				String line = in . readLine ();
				if (line == null)
					break;
				System.out . println (line);
				cm . sendLine (line);
			}
		}
		catch (IOException e)
		{
			e . printStackTrace ();
		}
		IoCloser.close (in);
		cm . shutDown ();
	}



}



