///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.logcast;



import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.PropertyResourceBundle;
import lava.util.ResourceLoader;



class Options
{



	// null means INET_ANY
	static InetAddress bind_address = null;



	static int bind_port = 0;



	static int max_connections = 1;



	static int backlog;



	static int buffer_size = 100;



	static File access_rules = new File ("access_rules");



	static void initialize (String filename) throws IOException
	{
		ResourceLoader rl = new ResourceLoader
		(
			new PropertyResourceBundle
			(
				new FileInputStream (filename)
			)
		);
		bind_address    = rl . getHost ("bind_address"   , bind_address   );
		bind_port       = rl . getInt  ("bind_port"      , bind_port      );
		max_connections = rl . getInt  ("max_connections", max_connections);
		backlog         = rl . getInt  ("backlog"        , max_connections);
		buffer_size     = rl . getInt  ("buffer_size"    , buffer_size    );
		access_rules    = rl . getFile ("access_rules"   , access_rules   );
	}



}



