///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.meow;



import java.net.MalformedURLException;
import lava.string.StringDecoder;
import java.applet.Applet;
import lava.string.WildcardExpression;
import java.net.URL;



class AudioBinding
{



	final WildcardExpression pattern;



	final URL sound;



	AudioBinding (WildcardExpression pattern, URL sound)
	{
		this . pattern = pattern;
		this . sound = sound;
	}



	boolean matches (String line)
	{
		return pattern . accept (line);
	}



	void play ()
	{
		Applet.newAudioClip (sound) . play ();
	}



	AudioBinding (String pattern, String soundpath) throws MalformedURLException
	{
		this . pattern = new WildcardExpression
		(
			StringDecoder.decodeQuotedCString (pattern)
		);
		this . sound = new URL
		(
			StringDecoder.decodeQuotedCString (soundpath)
		);
	}



}



