///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  This source code is the proprietary information of Sharkysoft            //
//  (sharkysoft.com).  You may view it as a supplement to its accompanying   //
//  product documentation, and you are permitted to modify and recompile     //
//  it, but you may not distribute it or use it for any other purpose        //
//  without written consent from Sharkysoft.                                 //
//                                                                           //
//  If you modify this source code, please consider sharing your changes     //
//  with Sharkysoft for possible incorporation into future releases.         //
//  Thanks!                                                                  //
//                                                                           //
//  For more information about Sharkysoft and this software, visit the       //
//  Sharkysoft web site at                                                   //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Sharkysoft products!                                 //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package sharky.app.meow;



import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import lava.io.IoCloser;
import lava.io.IoToolbox;
import lava.io.StreamParser;
import lava.io.UnlimitedPushbackReader;



public class Main
{



	private static final String[] usage =
	{
		"meow, by Charlton Rose",
		"Copyright (c) 2000 Sharkysoft (sharkysoft.com).  All rights reserved.",
		"usage: java -jar meow.jar <map> <skip>"
	};



	private static String map_path;



	private static long map_date;



	private static Vector map = new Vector ();



	public static void main (String[] args) throws IOException
	{
		int skips = 0;
		switch (args . length)
		{
		case 2:
			skips = Integer.parseInt (args [1]);
		case 1:
			map_path = args [0];
			break;
		default:
			IoToolbox.printLines (usage);
			return;
		}
		main_loop (skips);
	}



	private static void main_loop (int skips) throws IOException
	{
		BufferedReader in = IoToolbox.getStdinReader ();
		while (true)
		{
			refresh_map ();
			String line = in . readLine ();
			if (line == null)
				break;
			if (skips > 0)
				-- skips;
			else
			{
				AudioBinding match = findMatch (line);
				if (match != null)
					match . play ();
			}
			System.out . println (line);
		}
	}



	private static void refresh_map ()
	{
		long new_map_date = new File (map_path) . lastModified ();
		if (new_map_date > map_date)
			try
			{
				load_map (new_map_date);
			}
			catch (IOException e)
			{
				System.err . println ("Error loading map: " + e);
			}
	}



	private static void load_map (long new_map_date) throws IOException
	{
		map_date = new_map_date;
		Vector new_map = new Vector ();
		UnlimitedPushbackReader map_in = null;
		try
		{
			map_in = new UnlimitedPushbackReader
			(
				IoToolbox.getConfigFileReader (map_path)
			);
			while (true)
			{
				StreamParser.tryWhiteString (map_in);
				if (IoToolbox.peek (map_in) < 0)
					break;
				String pattern = StreamParser.expectQuotedCString (map_in);
				StreamParser.expectHorizontalWhiteString (map_in);
				String sound = StreamParser.expectQuotedCString (map_in);
				new_map . addElement (new AudioBinding (pattern, sound));
				StreamParser.tryHorizontalWhiteString (map_in);
			}
		}
		finally
		{
			IoCloser.close (map_in);
		}
		map = new_map;
	}



	private static AudioBinding findMatch (String line)
	{
		Enumeration enum = map . elements ();
		while (enum . hasMoreElements ())
		{
			AudioBinding binding = (AudioBinding) enum . nextElement ();
			if (binding . matches (line))
				return binding;
		}
		return null;
	}



}



