/*
 * Decompiled with CFR 0.152.
 */
package lava.array;

import java.math.BigDecimal;
import lava.array.ArrayCaster;

public abstract class UnsignedArrayCaster
extends ArrayCaster {
    public static final byte[] toBytes(double[] dArray, int n, byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (dArray == null) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)dArray[n + n4];
            byArray[n2 + n4] = n5 > 255 ? -1 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return byArray;
    }

    public static final byte[] toBytes(float[] fArray, int n, byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (fArray == null) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)fArray[n + n4];
            byArray[n2 + n4] = n5 > 255 ? -1 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return byArray;
    }

    public static final char[] toChars(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (cArray == null) {
            cArray = new char[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            cArray[n2 + n4] = (char)(byArray[n + n4] & 0xFF);
            ++n4;
        }
        return cArray;
    }

    public static final char[] toChars(double[] dArray, int n, char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (dArray == null) {
            return null;
        }
        if (cArray == null) {
            cArray = new char[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)dArray[n + n4];
            cArray[n2 + n4] = n5 > 65535 ? 65535 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return cArray;
    }

    public static final char[] toChars(float[] fArray, int n, char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (fArray == null) {
            return null;
        }
        if (cArray == null) {
            cArray = new char[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)fArray[n + n4];
            cArray[n2 + n4] = n5 > 65535 ? 65535 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return cArray;
    }

    public static final double[] toDoubles(byte[] byArray, int n, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (dArray == null) {
            dArray = new double[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            dArray[n2 + n4] = byArray[n + n4] & 0xFF;
            ++n4;
        }
        return dArray;
    }

    public static final double[] toDoubles(int[] nArray, int n, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (nArray == null) {
            return null;
        }
        if (dArray == null) {
            dArray = new double[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            dArray[n2 + n4] = (long)nArray[n + n4] & 0xFFFFFFFFL;
            ++n4;
        }
        return dArray;
    }

    public static final double[] toDoubles(long[] lArray, int n, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (lArray == null) {
            return null;
        }
        if (dArray == null) {
            dArray = new double[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            long l = lArray[n + n4];
            dArray[n2 + n4] = (l & Long.MIN_VALUE) == 0L ? (double)l : (double)(l >>> 1) * 2.0 + (double)(l & 1L);
            ++n4;
        }
        return dArray;
    }

    public static final double[] toDoubles(short[] sArray, int n, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (sArray == null) {
            return null;
        }
        if (dArray == null) {
            dArray = new double[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            dArray[n2 + n4] = sArray[n + n4] & 0xFFFF;
            ++n4;
        }
        return dArray;
    }

    public static final float[] toFloats(byte[] byArray, int n, float[] fArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (fArray == null) {
            fArray = new float[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            fArray[n2 + n4] = byArray[n + n4] & 0xFF;
            ++n4;
        }
        return fArray;
    }

    public static final float[] toFloats(int[] nArray, int n, float[] fArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (nArray == null) {
            return null;
        }
        if (fArray == null) {
            fArray = new float[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            fArray[n2 + n4] = (long)nArray[n + n4] & 0xFFFFFFFFL;
            ++n4;
        }
        return fArray;
    }

    public static final float[] toFloats(long[] lArray, int n, float[] fArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (lArray == null) {
            return null;
        }
        if (fArray == null) {
            fArray = new float[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            long l = lArray[n + n4];
            fArray[n2 + n4] = (l & Long.MIN_VALUE) == 0L ? (float)l : (float)((double)(l >>> 1) * 2.0 + (double)(l & 1L));
            ++n4;
        }
        return fArray;
    }

    public static final float[] toFloats(short[] sArray, int n, float[] fArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (sArray == null) {
            return null;
        }
        if (fArray == null) {
            fArray = new float[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            fArray[n2 + n4] = sArray[n + n4] & 0xFFFF;
            ++n4;
        }
        return fArray;
    }

    public static final int[] toInts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = byArray[n + n4] & 0xFF;
            ++n4;
        }
        return nArray;
    }

    public static final int[] toInts(double[] dArray, int n, int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (dArray == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            double d2 = dArray[n + n4];
            nArray[n2 + n4] = d2 >= 4.294967295E9 ? -1 : (d2 >= 2.147483647E9 ? (int)d2 : (d2 > 0.0 ? (int)d2 : 0));
            ++n4;
        }
        return nArray;
    }

    public static final int[] toInts(float[] fArray, int n, int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (fArray == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            float f2 = fArray[n + n4];
            nArray[n2 + n4] = f2 >= 4.2949673E9f ? -1 : (f2 >= 2.1474836E9f ? (int)f2 : (f2 > 0.0f ? (int)f2 : 0));
            ++n4;
        }
        return nArray;
    }

    public static final int[] toInts(short[] sArray, int n, int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (sArray == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = sArray[n + n4] & 0xFFFF;
            ++n4;
        }
        return nArray;
    }

    public static final long[] toLongs(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (lArray == null) {
            lArray = new long[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            lArray[n2 + n4] = (long)byArray[n + n4] & 0xFFL;
            ++n4;
        }
        return lArray;
    }

    public static final long[] toLongs(double[] dArray, int n, long[] lArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (dArray == null) {
            return null;
        }
        if (lArray == null) {
            lArray = new long[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            double d2 = dArray[n + n4];
            lArray[n2 + n4] = d2 >= 1.8446744073709552E19 ? -1L : (d2 >= 9.223372036854776E18 ? new BigDecimal(d2).toBigInteger().longValue() : (d2 > 0.0 ? (long)d2 : 0L));
            ++n4;
        }
        return lArray;
    }

    public static final long[] toLongs(float[] fArray, int n, long[] lArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (fArray == null) {
            return null;
        }
        if (lArray == null) {
            lArray = new long[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            float f2 = fArray[n + n4];
            lArray[n2 + n4] = f2 >= 1.8446744E19f ? -1L : (f2 >= 9.223372E18f ? new BigDecimal(f2).toBigInteger().longValue() : (f2 > 0.0f ? (long)f2 : 0L));
            ++n4;
        }
        return lArray;
    }

    public static final long[] toLongs(int[] nArray, int n, long[] lArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (nArray == null) {
            return null;
        }
        if (lArray == null) {
            lArray = new long[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            lArray[n2 + n4] = (long)nArray[n + n4] & 0xFFFFFFFFL;
            ++n4;
        }
        return lArray;
    }

    public static final long[] toLongs(short[] sArray, int n, long[] lArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (sArray == null) {
            return null;
        }
        if (lArray == null) {
            lArray = new long[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            lArray[n2 + n4] = (long)sArray[n + n4] & 0xFFFFL;
            ++n4;
        }
        return lArray;
    }

    public static final short[] toShorts(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (byArray == null) {
            return null;
        }
        if (sArray == null) {
            sArray = new short[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            sArray[n2 + n4] = (short)(byArray[n + n4] & 0xFF);
            ++n4;
        }
        return sArray;
    }

    public static final short[] toShorts(double[] dArray, int n, short[] sArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (dArray == null) {
            return null;
        }
        if (sArray == null) {
            sArray = new short[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)dArray[n + n4];
            sArray[n2 + n4] = n5 > 65535 ? -1 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return sArray;
    }

    public static final short[] toShorts(float[] fArray, int n, short[] sArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("amt==" + n3);
        }
        if (fArray == null) {
            return null;
        }
        if (sArray == null) {
            sArray = new short[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)fArray[n + n4];
            sArray[n2 + n4] = n5 > 65535 ? -1 : (n5 < 0 ? 0 : (int)n5);
            ++n4;
        }
        return sArray;
    }
}

