///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import lava.io.UnlimitedPushbackReader;
import lava.io.UrlInputStream;
import lava.string.StringEncoder;
import lava.text.ParallelColumnsWriter;
import lava.text.html.HtmlComponent;
import lava.text.html.HtmlParser;



class parseHtml
{



	public static void main (String[] args) throws Exception
	{
		if (args . length != 1)
		{
			System.out . println ("usage: parseHtml <url>");
			return;
		}
		HtmlParser hp = new HtmlParser
		(
			new UnlimitedPushbackReader
			(
				new InputStreamReader
				(
					new UrlInputStream (args [0])
				)
			)
		);
		ParallelColumnsWriter pcw = new ParallelColumnsWriter
		(
			new OutputStreamWriter (System.out),
			new int[] {15, 60}
		);
		while (true)
		{
			HtmlComponent c = hp . parse ();
			if (c == null)
				break;
			String clname = c . getClass () . getName ();
			clname = clname . substring (clname . lastIndexOf ('.') + 1);
			pcw . writeln
			(
				new String[]
				{
					clname,
					StringEncoder.encodeAsciiJavaString (c . getSource ())
				}
			);
		}
		pcw . close ();
		hp . close ();
	}



}



