///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava;



/******************************************************************************
Indicates an unfinished execution path.

<p><b>Details:</b> A <code>NotImplementedException</code> is thrown when a method is called, a case invoked, or a feature is requested that has not yet been implemented.  This class is for developers; it makes it possible to compile code before all of it has been written, while minimizing the risk of forgetting to finish it later.  Simply include the statement</p>

<ul><code>
throw new lava.NotImplementedException ();
</code></ul>

<p>in any method or execution path that you'd like to finish later, and the compiler will let you compile the code without forcing you to insert dummy return values, etc., which you might forget about later.</p>

<ul>
	<p><b>Example:</b></p>

	<pre>
	*public static float [] findPolynomialRoots (Polynomial p)
	*{
	*	// I'm putting this declaration here
	*	// so that the rest of my code will compile,
	*	// but I'll implement the body later.
	*	throw new lava.NotImplementedException ();
	*}
	</pre>
</ul>

<p><code>NotImplementedException</code> is extremely handy if you're the kind of programmer who likes to design classes "on the fly," by setting up "method stubs" to fill in later.  By using <code>NotImplementedException</code> to mark unfinished execution paths, you can guarantee that you'll eventually get back to them, because if you forget, the JVM will let you know about it -- down to the class, method, and line number!</p>

@since before 1998
@version 1999.04.19
******************************************************************************/

public class NotImplementedException
	extends RuntimeException
{



	/**********************************************************************
	Initializes without message.

	<p><b>Details:</b>  This default constructor initializes a new <code>NotImplementedException</code> without an exception message.</p>
	**********************************************************************/

	public NotImplementedException ()
	{
		super ();
	}



	/**********************************************************************
	Initializes with message.

	<p><b>Details:</b>  This constructor initializes a new <code>NotImplementedException</code> with the given exception message.</p>

	@param s the messsage
	**********************************************************************/

	public NotImplementedException (String s)
	{
		super (s);
	}



	/**********************************************************************
	Prints stack trace without throwing.

	<p><b>Details:</b>  <code>trace</code> instantiates a new <code>NotImplementedException</code> without throwing it, and then outputs its stack trace to <code>System.err</code>.  This is useful for tracking unfinished code paths which must be allowed to operate, albeit temporarily, in their unfinished state.</p>

	@since 1999.06.04
	**********************************************************************/

	public static void trace ()
	{
		new NotImplementedException () . printStackTrace ();
	}



}



