///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava;



/******************************************************************************
Indicates an unsupported feature.

<p><b>Details:</b> A <code>NotSupportedException</code> is thrown when a feature is requested that may ultimately be supported, but is not yet supported in the current version of the software.  This class makes it possible to lay out the structure for future features without requiring you to immediately implement them.</p>

@since 1999.04.19

<!--SHOWSOURCE-->
******************************************************************************/

public class NotSupportedException
	extends NotImplementedException
{



	/**********************************************************************
	Initializes a new instance with no message.
	**********************************************************************/

	public NotSupportedException ()
	{
		super ();
	}



	/**********************************************************************
	Initializes a new instance with the given message.

	@param s the message
	**********************************************************************/

	public NotSupportedException (String s)
	{
		super (s);
	}



}



