///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava;



/******************************************************************************
Characterizes the host platform.

<p><b>Details:</b>  <code>Platform</code> provides information about the current platform on which the JVM is running.  This class does not provide any additional information beyond that which is already available through <code>System.getProperty</code> calls, but hopefully it <em>does</em> make access to -- and interpretation of -- that information a bit easier.</p>

<p>This class is always under development as new Java platforms are being introduced.  If you wish to encourage the development of this class, please return the output of the following code:</p>

<form>
<textarea rows=10 cols=80 onChange="this.form.reset();">
*import java.util.Enumeration;
*import java.util.Properties;
*
*
*
*class DumpProperties
*{
*
*
*
*	public static void main (String[] args)
*	{
*		Properties p = System.getProperties ();
*		Enumeration keys = p . keys ();
*		while (keys . hasMoreElements ())
*		{
*			String key = (String) keys . nextElement ();
*			String value = (String) p . get (key);
*			System.out . println (key + "=" + value);
*		}
*	}
*
*
*
*}
*
*
*
*
</textarea></form>

<p>Currently available dumps are available <a href="doc-files/dumps.htm">here</a>.</p>

@version 2000.01.22
@since 1999.04.01
******************************************************************************/

public class Platform
{



	/**********************************************************************
	Indicates unknown information.

	<p><b>Details:</b>  <code>UNKNOWN</code> indicates that some item of information could not be determined.  For example, if you are caching the return value of <code>get_os_genre</code>, you can cache this value to avoid clashes with the other constants defined in this class.</p>
	**********************************************************************/

	public static final int UNKNOWN = 0;



	/**********************************************************************
	Unix-style operating system.

	<p><b>Details:</b>  UNIX indicates any of the Unix-style operating systems.</p>
	**********************************************************************/

	public static final int UNIX = 1;



	/**********************************************************************
	Microsoft MS-DOS operating system.

	<p><b>Details:</b>  MS_DOS indicates the Microsoft MS-DOS operating system family.</p>
	**********************************************************************/

	public static final int MS_DOS = 2;



	/**********************************************************************
	Apple Macintosh operating system.

	<p><b>Details:</b>  MACINTOSH indicates the Apple Macintosh operating system family.</p>
	**********************************************************************/

	public static final int MACINTOSH = 3;



	/**********************************************************************
	Microsoft Windows.

	<p><b>Details:</b>  WINDOWS indicates the Microsoft Windows operating system family.</p>
	**********************************************************************/

	public static final int WINDOWS = 4;



	private static int os_genre = UNKNOWN;



	/**********************************************************************
	Determines host operating system family.

	<p><b>Details:</b>  <code>get_os_genre</code> identifies the operating system genre hosting the currently running JVM.</p>

	<p>This implementation recognizes only Linux (UNIX), Windows (WINDOWS), Macintosh (MACINTOSH), and HP-UX (UNIX).  If the initialization procedure detects any other platform, it will assume UNIX.</p>

	<p>The author is currently in the process of collecting <code>System.getProperty("os.name")</code> values for as many platforms as possible, so that the initialization procedure can be expanded.  Submissions are welcome.</strong></p>
	**********************************************************************/

	public static final synchronized int getOsGenre ()
	{
		if (os_genre != UNKNOWN)
			return os_genre;
		String s = System.getProperty ("os.name");
		// More cases need to be added here!  Volunteers, please provide information.
		if (s . startsWith ("Windows"))
			os_genre = WINDOWS;
		else if (s . startsWith ("Linux"))
			os_genre = UNIX;
		else if (s . startsWith ("Mac"))
			os_genre = MACINTOSH;
		else if (s . startsWith ("HP-UX"))
			os_genre = UNIX;
		else
			os_genre = UNIX;
		return os_genre;
	}



	private static String default_line_separator;



	/**********************************************************************
	Returns platform's line separator.

	<p><b>Details:</b>  getLineSeparator returns the default line separator for the host platform.</p>

	@return the line separator
	@since 2000.01.29
	**********************************************************************/

	public static final synchronized String getLineSeparator ()
	{
		if (default_line_separator == null)
			default_line_separator = System.getProperty ("line.separator");
		return default_line_separator;
	}



}



