///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.Reader;
import java.io.IOException;
import java.io.InputStream;



/******************************************************************************
Converts byte stream to char stream without decoding.

<p><b>Details:</b>  AsciiInputStreamReader converts a binary InputStream to a Reader.  Each byte from the source InputStream is converted to a char.  This class is useful for parsing streams that contain mixtures of ASCII and binary data.</p>

<!-- Formerly lava.array.BinaryInputStreamReader -->

@since 1998.09.27
******************************************************************************/

public final class AsciiInputStreamReader
	extends Reader
{



	/**********************************************************************
	The InputStream that this instance reads from.
	**********************************************************************/

	private final InputStream in;



	/**********************************************************************
	Initializes with InputStream.

	<p><b>Details:</b>  This constructor initializes a new <code>AsciiInputStreamReader</code> with the given <code>InputStream</code>.</p>

	@param in the InputStream
	**********************************************************************/

	public AsciiInputStreamReader (InputStream in)
	{
		this . in = in;
	}



	/**********************************************************************
	Reads one byte.

	<p><b>Details:</b>  <code>read</code> reads a single <code>byte</code> from the <code>InputStream</code> and returns it as a <code>char</code>.</p>

	@return the byte
	**********************************************************************/

	public int read () throws IOException
	{
		return in . read ();
	}



	/**********************************************************************
	Reads bytes from the input stream.

	<p><b>Details:</b> <code>read</code> reads <var>len</var> <code>byte</code>s from the <code>InputStream</code>, converts them to <code>char</code>s, and stores them in <var>buff</var>, beginning at offset <var>off</var>.  The return value is the number of bytes read and converted, or -1 if no <code>byte</code>s were read and the EOS was reached.</p>

	@param buff the destination buffer
	@param off the offset
	@param len the number of bytes to read
	@return the number of bytes read
	@exception IOException if an I/O error occurs
	**********************************************************************/

	public int read (char [] buff, int off, int len) throws IOException
	{
		int i;
		for (i = 0; i < len; ++ i)
		{
			int c = in . read ();
			if (c < 0)
				break;
			buff [off + i] = (char) c;
		}
		if (i == 0)
			return -1;
		return i;
	}



	/**********************************************************************
	Closes this <code>Reader</code>.

	<p><b>Details:</b>  <code>close</code> closes the source <code>InputStream</code> by calling it's <code>close</code> method.

	@exception IOException if an I/O error occurs
	**********************************************************************/

	public void close () throws IOException
	{
		in . close ();
	}



}



