///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.FileNotFoundException;
import java.io.File;



/******************************************************************************
Indicates invalid directory name.

<p><b>Details:</b> A <code>DirectoryNotFoundException</code> indicates that a specified directory could not be found, presumably because it doesn't exist.</p>

<!--SHOWSOURCE-->
******************************************************************************/

public class DirectoryNotFoundException extends FileNotFoundException
{



	/**********************************************************************
	Constructs an instance of this class with no detail message.
	**********************************************************************/

	public DirectoryNotFoundException ()
	{
		super ();
	}



	/**********************************************************************
	Constructs an instance of this class with a detail message specifying the invalid directory name.

	@param f the file that should have been a directory, but was not
	**********************************************************************/

	public DirectoryNotFoundException (File f)
	{
		super (f . toString ());
	}



	/**********************************************************************
	Constructs an instance of this class with the given detail message.

	@param s the detail message
	**********************************************************************/

	public DirectoryNotFoundException (String s)
	{
		super (s);
	}



}



