///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.Reader;
import java.io.FilterReader;
import java.io.IOException;



/******************************************************************************
Modified FilterReader.

<p><b>Details:</b>  If you are tempted to use <code>java.io.FilterReader</code>, try this class instead.  An <code>LFilterReader</code> is essentially a <code>java.io.FilterReader</code>, except that <code>read(char[])</code> is <code>final</code>.  Since all known <code>read(char[])</code> implementations simply forward to <code>read(char[],int,int)</code> anyway, there is very little reason to override the former when the latter must be overridden as well.  (It would be bad design to give the two <code>read</code>s different behavior.)  Therefore, it is sufficient to override <code>read(char[],int,int)</code> in a subclass and continue allowing the superclass's implementation of <code>read(char[])</code> to forward to the other read.  Additionally, making <code>read(char[])</code> final helps prevents unexpected polymorphic loops in poorly designed code.</p>

@version 2000.01.29
@since 1998 (&lt;1998.11.11)
******************************************************************************/

public abstract class LFilterReader
	extends FilterReader
{



	/**********************************************************************
	Sets forwarding to Reader.

	<p><b>Details:</b>  This constructor sets the input source to <var>reader</var>.  All input requested from this Reader will be taken from <var>reader</var>.</p>

	@param reader the input source
	**********************************************************************/

	public LFilterReader (Reader reader)
	{
		super (reader);
	}



	/**********************************************************************
	Reads characters.

	<p><b>Details:</b>  This implementation of <code>read</code> forwards to</p>

	<blockquote>
		<code>read (dest, 0, dest . length)</code>.
	</blockquote>

	<p>See <code>read(char[],int,int)</code> for more information.</p>

	@param dest the destination array
	@return number of characters stored
	@exception IOException if an I/O error occurs
	**********************************************************************/

	public final int read (char[] dest) throws IOException
	{
		return read (dest, 0, dest . length);
	}



}



