///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.InputStream;



/******************************************************************************
Empty input stream.

<p><b>Details:</b>  <code>NullInputStream</code> is an empty (zero-<wbr>length) input stream with no contents.  The first call to <code>read</code> immediately returns the EOS token (-1).</p>

@since 2000.02.10
@author Sharky
******************************************************************************/

public class NullInputStream
	extends InputStream
{



	/**********************************************************************
	Returns EOS token.

	<p><b>Details:</b>  <code>read</code> returns -1, the end-<wbr>of-<wbr>stream token.</p>

	@return -1
	**********************************************************************/

	public int read ()
	{
		return -1;
	}



	/**********************************************************************
	True.

	<p><b>Details:</b>  <code>markSupported</code> returns <code>true</code>, since it is trivial to mark a position within a zero-<wbr>length input stream.</p>

	@return true
	**********************************************************************/

	public boolean markSupported ()
	{
		return true;
	}



	/**********************************************************************
	No operation.

	<p><b>Details:</b>  <code>reset</code> does absolutely nothing.</p>
	**********************************************************************/

	public void reset () {}



}



