///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.IOException;



/******************************************************************************
Indicates incompatible stream format.

<p><b>Details:</b> A <code>StreamFormatException</code> indicates that the data read from a stream does not conform to the rules defined for the type of stream being read.</p>

@see FileFormatException
******************************************************************************/

public class StreamFormatException extends IOException
{



	/**********************************************************************
	Initializes a new <code>StreamFormatException</code> with no detail message.
	**********************************************************************/

	public StreamFormatException ()
	{
		super ();
	}



	/**********************************************************************
	Initializes a new <code>StreamFormatException</code> with the specified detail message.

	@param s the detail message
	**********************************************************************/

	public StreamFormatException (String s)
	{
		super (s);
	}



}



