///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.File;



class TemporaryFile
{



	/*********************************************************************
	A prefix for temporary filenames.
	*********************************************************************/

	private static final String prefix = "~TeMp";



	/*********************************************************************
	Number of temp files we've tried to created so far.
	*********************************************************************/

	private static int tries = 0;



	/*********************************************************************
	Determines a filename for the temporary file and returns a file object representing it.
	*********************************************************************/

	static synchronized File choose_file (File dir)
	{
		if (! dir . isDirectory ())
		{
			// Maintain 1.1 compatibility:
			// dir = dir . getParentFile ();
			String p = dir . getParent ();
			if (p == null)
				p = ".";
			dir = new File (p);
		}
		// Would like to use File.createNewFile to make this thing totall thread-safe, but that would break 1.1 compatibility:
		File dest;
		do {
			dest = new File (dir, prefix + (System . currentTimeMillis () + tries ++));
		} while (dest . exists ());
		return dest;
	}



}



