///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;



/******************************************************************************
Reads from URL-specified source.

<p><b>Details:</b>  This is a convenience class that allows quick creation of an InputStream from a URL string.  Simply pass the URL to the constructor and the newly constructed instance is an input stream that reads from the resulting URL.</p>
******************************************************************************/

public class UrlInputStream
	extends FilterInputStream
{



	/**********************************************************************
	Sets source URL.

	<p><b>Details:</b>  This constructor sets the URL of the resource from which this InputStream reads.</p>

	@param url the URL
	@exception IOException if the resource cannot be read
	**********************************************************************/

	public UrlInputStream (String url) throws IOException
	{
		super (new URL (url) . openStream ());
	}



}



