///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.io;



import java.io.File;
import java.io.FilenameFilter;
import java.util.Stack;
import lava.Platform;
import lava.string.WildcardExpression;



/******************************************************************************
Filters filenames using a standard wildcard mask.

<p><b>Details:</b>  <code>WildcardFilenameFilter</code> tests filenames to determine their membership in the group of filenames defined by a wildcard expression.  The characters '?' and '*' take on their usual meanings; '?' means "any character" and '*' means "any string of zero or more characters."</p>

<p>Note that in this implementation, the wildcards may be used to match the platform's directory separator characters, so care should be taken to avoid this effect if it is not desired.</p>

@version 1999.04.01
@since 1997
******************************************************************************/

public class WildcardFilenameFilter implements FilenameFilter
{



	/**********************************************************************
	SUMMARY FORTHCOMING

	<p><b>Details:</b>  DETAILS FORTHCOMING</p>

	@since 1999.04.01
	**********************************************************************/

	private final boolean normalizing;



	/**********************************************************************
	SUMMARY FORTHCOMING

	<p><b>Details:</b>  DETAILS FORTHCOMING</p>
	**********************************************************************/

	private final WildcardExpression expression;



	/**********************************************************************
	Reserved for future implementation.  Initializes a WildcardFilenameFilter using the given wildcard expression and file separator.

	@param mask the filename mask
	@param file_separators a list of characters that should not be allowed to match '*' or '?'
	@version 1999.04.01
	**********************************************************************/

	public WildcardFilenameFilter (String mask, String file_separators)
	{
		normalizing = true;
		expression = new WildcardExpression (normalizeMask (mask), file_separators);
	}



	/**********************************************************************
	Initializes a WildcardFilenameFilter using the given wildcard expression.  '*' and '?' may match any character, including file separators.

	@param mask the wildcard expression
	@version 1999.04.01
	**********************************************************************/

	public WildcardFilenameFilter (String mask)
	{
		normalizing = true;
		expression = new WildcardExpression (normalizeMask (mask));
	}



	/**********************************************************************
	Determines if the given filename matches the expression associated with this <code>FilenameFilter</code>.  The <code>dir</code> parameter is reserved for future use, and should be set to <code>null</code> to ensure compatibility with future releases of this class.

	@param dir ignored, set to <code>null</code>
	@param filename the filename to test
	@return <code>true</code> if the filename passes, <code>false</code> otherwise
	@version 1999.04.01
	**********************************************************************/

	public boolean accept (File dir, String filename)
	{
		// normalizing is always true right now, but it may not always be so in the future
		if (normalizing)
			filename = normalizeMask (filename);
		return expression . accept (filename);
	}



	/**********************************************************************
	Normalizes the filename mask.

	<p><b>Details:</b>  <code>normalizeMask</code> normalizes the given mask into a form suitable for filename comparison on the host platform.  This means, in particular, that if the operating system does not support case-sensitive filename differentiation (as is the case with Windows and Mac), that the mask characters are converted to upper case.  On a Unix-style operating system, the original value is returned because upper and lower case distinctions are significant.</p>

	<p>If the mask is null, null is returned.</p>

	@param mask the mask to adjust
	@return the adjusted mask

	@since 1999.04.01
	**********************************************************************/

	public static String normalizeMask (String mask)
	{
		if (mask == null)
			return mask;
		switch (Platform.getOsGenre ())
		{
		case Platform.WINDOWS:
		case Platform.MACINTOSH:
			return mask . toUpperCase ();
		case Platform.UNIX:
			return mask;
		}
		throw new lava.NotImplementedException ();
	}



}



