///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.konst;



/******************************************************************************
Long constants.

<p><b>Details:</b>  <code>LONG</code> is a collection of <code>long</code> constants.</p>

@since 1999.05.13
******************************************************************************/

public class LONG
{



	/**********************************************************************
	0x7fffffffffffffff.

	<p><b>Details:</b>  Maximum signed <code>long</code> value.</p>
	**********************************************************************/

	public static final long MAX_SLONG  = 0x7fffffffffffffffL;



	/**********************************************************************
	0x8000000000000000.

	<p><b>Details:</b>  Minimum signed <code>long</code> value.</p>
	**********************************************************************/

	public static final long MIN_SLONG  = 0x8000000000000000L;



	/**********************************************************************
	0x000000007fffffff.

	<p><b>Details:</b>  Maximum signed <code>int</code> value.</p>
	**********************************************************************/

	public static final long MAX_SINT   = 0x000000007fffffffL;



	/**********************************************************************
	0xffffffff80000000.

	<p><b>Details:</b>  Minimum signed <code>int</code> value.</p>
	**********************************************************************/

	public static final long MIN_SINT   = 0xffffffff80000000L;



	/**********************************************************************
	0x00000000ffffffff.

	<p><b>Details:</b>  Maximum unsigned <code>int</code> value.</p>
	**********************************************************************/

	public static final long MAX_UINT   = 0x00000000ffffffffL;



	/**********************************************************************
	0x0000000000000000.

	<p><b>Details:</b>  Minimum unsigned <code>int</code> value.</p>
	**********************************************************************/

	public static final long MIN_UINT   = 0x0000000000000000L;



}



