///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.string;



/******************************************************************************
Character stack.

<p><b>Details:</b> A <code>CharacterStack</code> is a LIFO queue of characters suitable for use in various text parsing applications.  Characters are popped and pushed one at a time, but entire strings of characters can also be pushed with a single call.  For character stacking, this class is more efficient than the <code>java.util.Stack</code> class because it does not require object encapsulation for the characters.</p>

@author Sharky
******************************************************************************/

public class CharacterStack
{



	private final StringBuffer buff = new StringBuffer ();



	/**********************************************************************
	Initializes empty character stack.
	**********************************************************************/

	public CharacterStack ()
	{
	}



	private void _push (char c)
	{
		buff . append (c);
	}



	/**********************************************************************
	Pushes character.

	<p><b>Details:</b>  <code>push</code> pushes a character onto the stack.</p>

	@param c the character
	**********************************************************************/

	public void push (char c)
	{
		_push (c);
	}



	/**********************************************************************
	Pushes string.

	<p><b>Details:</b>  Pushes a string of characters onto the stack.  The first character of the string is pushed first.</p>

	@param s the string
	**********************************************************************/

	public void push (String s)
	{
		buff . append (s);
	}



	/**********************************************************************
	Pushes characters.

	<p><b>Details:</b>  <code>push</code> pushes an array of characters onto the stack.</p>

	@param src the array

	@since 2000.06.03
	**********************************************************************/

	public final void push (char[] src)
	{
		push (src, 0, src . length);
	}



	/**********************************************************************
	Pushes characters.

	<p><b>Details:</b>  <code>push</code> pushes an array of characters (<var>src</var>) onto the stack, starting with the character at the given offset (<var>offset</var>), and pushing only <var>amt</var> characters.</p>

	@param src the array
	@param offset the offset
	@param amt number of characters

	@since 2000.06.03
	**********************************************************************/

	public void push (char[] src, int offset, int amt)
	{
		for (int i = 0; i < amt; ++ i)
			_push (src [offset + i]);
	}



	/**********************************************************************
	Pops character.

	<p><b>Details:</b>  Pops a single character from the stack and returns it.  If the stack is empty, -1 is returned.</p>

	@return popped character
	**********************************************************************/

	public int pop ()
	{
		if (buff . length () == 0)
			return -1;
		int length = buff . length () - 1;
		char c = buff . charAt (length);
		buff . setLength (length);
		return c;
	}



	/**********************************************************************
	Returns stack height.

	<p><b>Details:</b>  Returns the number of characters currently on the stack.</p>

	@return stack height
	**********************************************************************/

	public int size ()
	{
		return buff . length ();
	}



	/**********************************************************************
	Clones stack.

	<p><b>Details:</b>  Returns an independent copy of this character stack.  Useful for "backing up" the stack.</p>

	@return copy
	**********************************************************************/

	public Object clone ()
	{
		CharacterStack copy = new CharacterStack ();
		copy . push (buff . toString ());
		return copy;
	}



}



