///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.string;



/******************************************************************************
Defines character class.

<p><b>Details:</b> An ICharacterClass defines membership of a character in a specific class of characters.  This interface is used primarily by {@link lava.io.StreamParser <code>StreamParser</code>}.</p>

@author Sharky
******************************************************************************/

public interface ICharacterClass
{



	/**********************************************************************
	Determines membership.

	<p><b>Details:</b>  isMember returns true if and only if the character <var>c</var> is a member of this character class.</p>

	@param c character to test
	@return true iff member
	**********************************************************************/

	boolean isMember (int c);



}



