///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.string;



import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;



/******************************************************************************
Collates non-string objects.

<p><b>Details:</b>  ToStringCollator functions nearly identically to java.text.Collator, but with one minor improvement: Collation can now occur between Objects that are not Strings.  When non-String Objects are collated, this Collator wrapper class automatically converts the Objects to Strings using each Object's toString method.</p>

@since 1999.04.25
******************************************************************************/

public class ToStringCollator
	extends Collator
{



	private final Collator c;



	private ToStringCollator (Collator c)
	{
		this . c = c;
	}



	public static Collator getInstance ()
	{
		return new ToStringCollator (Collator.getInstance ());
	}



	public static Collator getInstance (Locale l)
	{
		return new ToStringCollator (Collator.getInstance (l));
	}



	public CollationKey getCollationKey (String s)
	{
		return c . getCollationKey (s);
	}



	public int compare (String s1, String s2)
	{
		return c . compare (s1, s2);
	}



	public int compare (Object o1, Object o2)
	{
		return c . compare (o1 . toString (), o2 . toString ());
	}



	public int hashCode()
	{
		return c . hashCode ();
	}



}



