///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.string;



import java.util.Stack;



/******************************************************************************
Tests strings against wildcard expressions.

<p><b>Details:</b> A <code>WildcardExpression</code> is a template for testing whether strings belong in a certain string class.  <code>WildcardExpression</code>s can contain any number of literal characters and the two supported wildcard characters, '?' and '*', which are understood in the usual command shell fashion:</p>

<dl compact>
 <dt>'*'
  <dd>matches any sequence of characters, of any length, including zero length
 <dt>'?'
  <dd>matches any single character
</dl>

@since 1997
@version 2000.11.08
******************************************************************************/

public class WildcardExpression
{



	/**********************************************************************
	The characters of this expression, after the expression has been normalized.
	**********************************************************************/

	private char[] expression;
	private String excludes;



	/**********************************************************************
	Reserved.

	<p><b>Details:</b> Reserved for future implementation.  Constructs a <code>WildcardExpression</code> using the given <code>String</code>.  Wildcards '?' and '*' will not be allowed to match characters in the <code>excludes</code> string.</p>

	@param expression the wildcard expression
	@param excludes a list of character that should not be wild-matched
	**********************************************************************/

	public WildcardExpression (String expression, String excludes)
	{
		this . expression = normalize (expression) . toCharArray ();
		this . excludes = excludes;
		throw new lava.NotImplementedException ();
	}



	/**********************************************************************
	Sets expression string.

	<p><b>Details:</b> Constructs a <code>WildcardExpression</code> using the given <code>String</code>.</p>
	**********************************************************************/

	public WildcardExpression (String expression)
	{
		this . expression = normalize (expression) . toCharArray ();
	}



	/**********************************************************************
	Normalizes expression.

	<p><b>Details:</b> Normalizes a wildcard expression by expressing it in canonical form.  The canonical form of a wildcard expression does not contain the substrings "*?" or "**".  For any given wildcard expression, the canonical form of that expression is uniquely defined.  Any two equivalent wildcard expressions have the same canonical form.</p>

	@param expression the expression to normalize
	@return the normalized expression
	**********************************************************************/

	public static String normalize (String expression)
	{
		int length = expression . length ();
		StringBuffer new_expression = new StringBuffer ();
		boolean star_is_pending = false;
		for (int i = 0; i < length; ++ i)
		{
			char c = expression . charAt (i);
			switch (c)
			{
			default:
				if (star_is_pending)
				{
					new_expression . append ('*');
					star_is_pending = false;
				}
				// fall through
			case '?':
				new_expression . append (c);
				break;
			case '*':
				star_is_pending = true;
			}
		}
		if (star_is_pending)
		{
			new_expression . append ('*');
			star_is_pending = false;
		}
		return new_expression . toString ();
	}



	/**********************************************************************
	Tests string.

	<p><b>Details:</b> <code>accept</code> tests the given string against this wildcard expression.</p>

	@param cand the string to test
	@return <code>true</code> if the string passes, <code>false</code> otherwise
	**********************************************************************/

	public boolean accept (String cand)
	{
//System.err.println("WildcardExpression("+this+").accept("+cand+")");
		char [] candidate = cand . toCharArray ();
		int m = 0;
		int f = 0;
		Stack m_stack = new Stack ();
		Stack f_stack = new Stack ();
matching:
		while (true)
		{
			if (f == candidate . length)
			{
				if
				(
					m == expression . length
				||	(
						m + 1 == expression . length
					&&	expression [m] == '*'
					)
				)
					return true;
			}
			else if (m < expression . length)
				switch (expression [m])
				{
				default:
					if (expression [m] != candidate [f])
						break;
					// fall through
				case '?':
					++ m;
					++ f;
					continue matching;
				case '*':
					// If '*' is the last character in the expression and we have made it this far, then the match is guaranteed:
					if (m + 1 == expression . length)
						return true;

					for (int i = f; i < candidate . length; ++ i)
						if (candidate [i] == expression [m + 1])
						{
							m_stack . push (new Integer (m));
							f_stack . push (new Integer (i + 1));
							++ m;
							f = i;
							continue matching;
						}
				}

			// The current matching route has failed.
			// See if there are others to follow:
			if (m_stack . empty ())
				break;
			m = ((Integer) m_stack . pop ()) . intValue ();
			f = ((Integer) f_stack . pop ()) . intValue ();
		}
		return false;
	}



	/**********************************************************************
	Returns string representation.

	<p><b>Details:</b>  <code>toString</code> returns this wildcard expression as a string.  The returned string may not be identical to the string passed to the constructor, but it <em>will</em> be equivalent.</p>

	@return string representation

	@since 2000.11.08
	**********************************************************************/

	public String toString ()
	{
		return new String (expression);
	}



}



