///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.text.html;



import java.util.Enumeration;
import java.util.Hashtable;



/******************************************************************************
Closing HTML tag.

<p><b>Details:</b>  This class represents HTML close tags that have been parsed from an HTML source stream.  Instances of this class are returned by the <code>HtmlParser.parse</code> method.</p>

@see HtmlParser#parse()

@version 2000.12.22
******************************************************************************/

public class HtmlCloseTag
	extends HtmlRegularTag
{



	public HtmlCloseTag (String type)
	{
		super (type);
	}



	/**********************************************************************
	Generates string representation.

	<p><b>Details:</b>  toString returns a string representation of this closing tag.  The string returned may not be exactly the same as the original text that was parsed to form this tag, but it should be equivalent by HTML standards.</p>

	@return the string representation
	**********************************************************************/

	public String toString ()
	{
		return "</" + type + ">";
	}



}



