///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.text.html;



/******************************************************************************
HTML comment.

<p><b>Details:</b>  This class represents comments within HTML source.  A comment begins with <code>&lt;--</code> and ends with <code>--&gt;</code>.</p>
******************************************************************************/

public class HtmlComment
	extends HtmlSpecialTag
{



	HtmlComment (String content)
	{
		super (content);
	}



	/**********************************************************************
	Returns original comment string.

	<p><b>Details:</b>  toString returns the exact string that was parsed from the original HTML source in order to construct this instance, including the opening and closing HTML comment markers.</p>

	@return the comment
	**********************************************************************/

	public String toString ()
	{
		return "<!--" + content + "-->";
	}



}



