///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.text.html;



import java.util.Enumeration;
import java.util.Hashtable;



/******************************************************************************
HTML tag.

<p><b>Details:</b>  This is the base class for regular HTML tags that occur in the body of well formed HTML source.</p>
******************************************************************************/

public abstract class HtmlRegularTag
	extends HtmlComponent
{



	final String type;



	HtmlRegularTag (String type)
	{
		this . type = type . toUpperCase ();
	}



	/**********************************************************************
	Returns tag type.

	<p><b>Details:</b>  getType returns the primary type of this tag.  To facilitate easy tag identification, the type is represented in upper case characters, regardless of how it appeared in the original HTML stream.</p>

	<p>For example, if the original HTML source represented by this instance is</p>

	<blockquote><code>
		&lt;a href="http://sharkysoft.com/" target=_top&gt;
	</code></blockquote>

	<p>then <code>getType</code> will return the string "A".</p>

	@return the type
	**********************************************************************/

	public String getType ()
	{
		return type;
	}



}



