///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Notice to licensees:                                                     //
//                                                                           //
//  This source code is the exclusive, proprietary intellectual property of  //
//  Sharkysoft (sharkysoft.com).  You may view this source code as a         //
//  supplement to other product documentation, but you may not distribute    //
//  it or use it for any other purpose without written consent from          //
//  Sharkysoft.                                                              //
//                                                                           //
//  You are permitted to modify and recompile this source code, but you may  //
//  not remove this notice.  If you add features to or fix errors in this    //
//  code, please consider sharing your changes with Sharkysoft for possible  //
//  incorporation into future releases of the product.  Thanks!              //
//                                                                           //
//  For more information about Sharkysoft products and services, please      //
//  visit Sharkysoft on the web at                                           //
//                                                                           //
//       http://sharkysoft.com/                                              //
//                                                                           //
//  Thank you for using Lava!                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



package lava.text.html;



import lava.io.IoToolbox;
import java.io.PushbackReader;
import java.io.IOException;



/******************************************************************************
Uninterpreted HTML text.

<p><b>Details:</b>  This class represents runs of uninterpreted text, such as what normally occurs between regular HTML tags.</p>

@version 2000.12.22
******************************************************************************/

public class HtmlText
	extends HtmlComponent
{



	final String text;



	public HtmlText (String text)
	{
		this . text = text;
	}



	/**********************************************************************
	Parses text field from stream.

	<p><b>Details:</b>  Parse reads a text field from an HTML stream (<var>pr</var>) and returns a (decoded) <code>HtmlText</code> instance representing it.</p>

	@param the HTML stream
	@return the parsed field
	@exception IOException if an I/O error occurs

	@since 2000.12.22
	**********************************************************************/

	public static HtmlText parse (PushbackReader pr) throws IOException
	{
		StringBuffer buff = new StringBuffer ();
		while (true)
		{
			int c = IoToolbox.peek (pr);
			if (c < 0 || c == '<')
				break;
			pr . read ();
			buff . append ((char) c);
		}
		if (buff . length () == 0)
			return null;
		String source = buff . toString ();
		HtmlText text = new HtmlText (HtmlEntities.decodeHtmlText (source));
		text . source = source;
		return text;
	}



	/**********************************************************************
	Returns text.

	<p><b>Details:</b>  getText returns the run of text represented by this instance.</p>

	@return the text
	**********************************************************************/

	public String getText ()
	{
		return text;
	}



	/**********************************************************************
	Returns text.

	<p><b>Details:</b>  toString returns the same value as getText.</p>

	@return the text
	**********************************************************************/

	public String toString ()
	{
		return HtmlEntities.encodeHtmlText (text);
	}



}



