/*
 * Decompiled with CFR 0.152.
 */
package lava.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import lava.Platform;
import lava.clib.Ctype;
import lava.io.IoToolbox;
import lava.io.LineSeparatorFilter;
import lava.io.StreamParser;
import lava.io.UnixLineReader;
import lava.io.UnlimitedPushbackReader;
import lava.string.NumberString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ConsoleDialog {
    private final UnlimitedPushbackReader a;
    private final Writer if;
    public String default_error_response = "invalid response" + LineSeparatorFilter.DEFAULT_SEPARATOR;
    private static final boolean do = Platform.getOsGenre() == 4;

    public ConsoleDialog(Reader reader, Writer writer) {
        this.a = new UnlimitedPushbackReader(new UnixLineReader(new BufferedReader(reader)));
        this.if = writer;
    }

    public ConsoleDialog(Reader reader) {
        this(reader, new OutputStreamWriter(System.out));
    }

    public ConsoleDialog() {
        this(new InputStreamReader(new BufferedInputStream(System.in, 1)));
    }

    public void send(String string) throws IOException {
        this.if.write(string);
        this.if.flush();
    }

    public void sendLine(String string) throws IOException {
        this.if.write(string);
        this.if.write(LineSeparatorFilter.DEFAULT_SEPARATOR);
        this.if.flush();
    }

    public String readLine() throws IOException {
        return IoToolbox.readLine(this.a);
    }

    public float queryFloat(String string, String string2) throws IOException {
        while (true) {
            Float f;
            this.send(string);
            String string3 = this.readLine();
            if (string3 == null) {
                throw new EOFException();
            }
            string3 = string3.trim();
            try {
                f = Float.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                f = null;
            }
            if (f != null) {
                return f.floatValue();
            }
            if (string2 == null) {
                return Float.MIN_VALUE;
            }
            this.send(string2);
        }
    }

    public float queryFloat(String string) throws IOException {
        return this.queryFloat(string, this.default_error_response);
    }

    public int queryInt(String string, int n, String string2) throws IOException {
        while (true) {
            this.send(string);
            String string3 = this.readLine();
            if (string3 == null) {
                throw new EOFException();
            }
            Integer n2 = NumberString.toSignedInt(string3 = string3.trim(), n);
            if (n2 != null) {
                return n2;
            }
            if (string2 == null) {
                return Integer.MIN_VALUE;
            }
            this.send(string2);
        }
    }

    public int queryInt(String string, int n) throws IOException {
        return this.queryInt(string, n, this.default_error_response);
    }

    public int queryInt(String string) throws IOException {
        return this.queryInt(string, 10, this.default_error_response);
    }

    public String[] queryWords(String string, String string2) throws IOException {
        this.send(string);
        Vector<String> vector = new Vector<String>();
        while (true) {
            StreamParser.tryHorizontalWhiteString(this.a);
            String string3 = StreamParser.tryShellArgument(this.a);
            if (string3 == null) {
                string3 = IoToolbox.readLine(this.a);
                if (string3 == null) {
                    throw new EOFException();
                }
                if (string3.length() == 0) break;
                vector.addElement(string3);
                break;
            }
            vector.addElement(string3);
        }
        int n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] queryWords(String string) throws IOException {
        return this.queryWords(string, this.default_error_response);
    }

    public String queryWord(String string, String string2) throws IOException {
        String[] stringArray;
        while (true) {
            if ((stringArray = this.queryWords(string, null)) == null) {
                return null;
            }
            if (stringArray.length == 1) break;
            if (string2 == null) {
                return null;
            }
            this.send(string2);
        }
        return stringArray[0];
    }

    public String queryWord(String string) throws IOException {
        return this.queryWord(string, this.default_error_response);
    }

    public char queryChar(String string, String string2) throws IOException {
        while (true) {
            String string3;
            if ((string3 = IoToolbox.readLine(this.a)) == null) {
                throw new EOFException();
            }
            if ((string3 = string3.trim()).length() == 1) {
                return string3.charAt(0);
            }
            if (string2 == null) break;
            this.send(string2);
        }
        return '\u0000';
    }

    public char queryChar(String string) throws IOException {
        return this.queryChar(string, this.default_error_response);
    }

    private static boolean a(String string) {
        return do && string.length() >= 2 && Ctype.isalpha(string.charAt(0)) && string.charAt(1) == ':';
    }

    private static File a(String string, String string2) {
        File file = new File(string2);
        if (file.isAbsolute()) {
            return file;
        }
        if (ConsoleDialog.a(string2)) {
            return file;
        }
        return new File(string, string2);
    }

    public File queryInputFile(String string, String string2, String string3) throws IOException {
        String string4;
        while ((string4 = this.queryWord(string)) != null) {
            File file = ConsoleDialog.a(string2, string4);
            if (file.exists() && file.isFile() && file.canRead()) {
                return file;
            }
            if (string3 == null) {
                return null;
            }
            this.send(string3);
        }
        return null;
    }

    public File queryInputFile(String string, String string2) throws IOException {
        return this.queryInputFile(string, string2, this.default_error_response);
    }

    public File queryOutputFile(String string, String string2, String string3) throws IOException {
        String string4;
        while ((string4 = this.queryWord(string)) != null) {
            File file = ConsoleDialog.a(string2, string4);
            if (!file.exists() || file.canWrite()) {
                return file;
            }
            if (string3 == null) {
                return null;
            }
            this.send(string3);
        }
        return null;
    }

    public File queryOutputFile(String string, String string2) throws IOException {
        return this.queryOutputFile(string, string2, this.default_error_response);
    }
}

