/*
 * Decompiled with CFR 0.152.
 */
package lava.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import lava.clib.Ctype;
import lava.io.HashCommentStripperReader;
import lava.io.IoCloser;

public final class IoToolbox {
    public static byte[] computeStreamDigest(InputStream inputStream, String string) throws IOException {
        byte[] byArray;
        try {
            int n;
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException(string);
            }
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            byte[] byArray2 = new byte[1024];
            while ((n = inputStream.read(byArray2)) >= 0) {
                messageDigest.update(byArray2, 0, n);
            }
            byArray = messageDigest.digest();
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            IoCloser.close(inputStream);
            throw throwable;
        }
        IoCloser.close(inputStream);
        return byArray;
    }

    public static void unread(PushbackReader pushbackReader, String string) throws IOException {
        pushbackReader.unread(string.toCharArray());
    }

    public static int peek(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if (n >= 0) {
            pushbackReader.unread(n);
        }
        return n;
    }

    public static String readLine(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = reader.read()) < 0) {
                if (stringBuffer.length() > 0) break;
                return null;
            }
            if (Ctype.isvspace(n)) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public static void printLines(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println(stringArray[n2]);
            ++n2;
        }
    }

    public static LineNumberReader getConfigFileReader(String string) throws IOException {
        return new LineNumberReader(new BufferedReader(new HashCommentStripperReader(new FileReader(string))));
    }

    public static BufferedReader getStdinReader() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in));
    }

    public static String preloadStream(Reader reader, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(n);
        while ((n2 = reader.read()) >= 0) {
            stringBuffer.append((char)n2);
        }
        reader.close();
        return stringBuffer.toString();
    }
}

