/*
 * Decompiled with CFR 0.152.
 */
package lava.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import lava.Platform;
import lava.UnreachableCodeException;
import lava.io.DirectoryNotFoundException;
import lava.io.IoCloser;
import lava.string.PathToolbox;
import lava.string.StringToolbox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Path
implements Comparable {
    private final String do;
    public static final int CONDITIONAL_RELATIVE = 1;
    public static final int FORCE_RELATIVE = 2;
    public static final int CHANGE_ROOT = 3;
    private static Path a = new Path("/");
    private static final Object if = new Object();

    public Path(String string) {
        this.do = PathToolbox.simplifyPath(string);
    }

    public Path(String string, String string2, int n) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = PathToolbox.resolveRelativePath(string, string2);
                break;
            }
            case 2: {
                string3 = PathToolbox.concatenatePaths(string, string2);
                break;
            }
            case 3: {
                string3 = PathToolbox.concatenatePaths(string, PathToolbox.simplifyPath("/" + string2));
                break;
            }
            default: {
                throw new IllegalArgumentException("mode=" + n);
            }
        }
        this.do = PathToolbox.simplifyPath(string3);
    }

    public Path(Path path, String string, int n) {
        this(path.do, string, n);
    }

    public Path(Path path, Path path2, int n) {
        this(path.do, path2.do, n);
    }

    public static Path getWorkingDirectory() {
        return Path.createFromJavaFile(new File(Path.char()));
    }

    private static String char() {
        return System.getProperty("user.dir");
    }

    public static final Path createFromJavaFile(File file) {
        if (Path.case()) {
            return Path.a(file);
        }
        return Path.if(file);
    }

    private static final Path if(File file) {
        return new Path(file.getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Path a(File file) {
        if (!Path.case()) {
            throw new UnreachableCodeException();
        }
        String string = file.getPath();
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("winpath=" + string);
        }
        if ((string = string.replace('\\', '/')).length() >= 2 && string.charAt(1) == ':') {
            char c = string.charAt(0);
            if ('a' <= c && c <= 'z') {
                c = (char)(c - 97 + 65);
            } else if (c < 'A' || 'Z' < c) {
                throw new IllegalArgumentException("winpath=" + string);
            }
            if (string.length() < 3 || string.charAt(2) != '/') return Path.a(file.getAbsoluteFile());
            string = "/" + c + "/" + string.substring(3);
            return new Path(string);
        } else {
            if (string.charAt(0) != '/' || n <= 1 || string.charAt(1) != '/') return new Path(string);
            string = "/NET/" + string.substring(2);
        }
        return new Path(string);
    }

    public File toJavaFile() {
        if (Path.case()) {
            return this.new();
        }
        return this.byte();
    }

    File byte() {
        return new File(this.do);
    }

    private File new() {
        return Path.a(this.do);
    }

    private static File a(String string) {
        char c;
        if ((string = string.replace('/', '\\')).charAt(0) != '\\') {
            return new File(string);
        }
        int n = string.length();
        switch (n) {
            case 0: {
                throw new UnreachableCodeException();
            }
            case 1: {
                return new File("\\");
            }
            case 2: {
                char c2 = string.charAt(1);
                if ('A' <= c2 && c2 <= 'Z') {
                    return new File(c2 + ":\\");
                }
                return new File(string);
            }
        }
        if (string.equals("\\NET")) {
            return new File("\\\\");
        }
        if (string.startsWith("\\NET\\")) {
            return new File("\\" + string.substring(4));
        }
        if (string.charAt(2) == '\\' && 'A' <= (c = string.charAt(1)) && c <= 'Z') {
            return new File(c + ":" + string.substring(2));
        }
        return new File(string);
    }

    public static Path getRootDirectory() {
        return a;
    }

    private static boolean case() {
        return Platform.getOsGenre() == 4;
    }

    private boolean else() {
        if (this.do.equals("/NET")) {
            return true;
        }
        return this.do.startsWith("/NET/") && StringToolbox.count(this.do, '/') == 2;
    }

    public final boolean isAbsolute() {
        return PathToolbox.isAbsolutePath(this.do);
    }

    public Path getParentDirectory() {
        return new Path(this.do + "/..");
    }

    public String getFileName() {
        return PathToolbox.getFilename(this.do);
    }

    public Path toAbsolutePath() {
        return new Path(Path.getWorkingDirectory().do, this.do, 1);
    }

    public Path toRelativePath(Path path) {
        if (this.isRelative()) {
            return this;
        }
        return new Path(PathToolbox.toRelativePath(path.do, this.do));
    }

    public Path toRelativePath() {
        return this.toRelativePath(Path.getWorkingDirectory());
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public Path getCanonicalPath() throws IOException {
        this.try();
        File file = this.toJavaFile();
        file = file.getCanonicalFile();
        return Path.createFromJavaFile(file);
    }

    public boolean exists() throws IOException {
        if (Path.case()) {
            return this.for();
        }
        File file = this.toJavaFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    private boolean for() throws IOException {
        if (this.do.equals("/")) {
            return true;
        }
        if (this.else()) {
            return true;
        }
        File file = this.new();
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        file = new Path(PathToolbox.simplifyPath(PathToolbox.resolveRelativePath(Path.getWorkingDirectory().do, this.do))).new();
        return file.getAbsolutePath().equals(file.getCanonicalPath());
    }

    private void try() throws IOException {
        if (this.exists()) {
            return;
        }
        throw new FileNotFoundException(this.do);
    }

    public boolean isDirectory() throws IOException {
        if (!this.exists()) {
            return false;
        }
        File file = this.toJavaFile();
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }

    public boolean isDataFile() throws IOException {
        if (!this.exists()) {
            return false;
        }
        File file = this.toJavaFile();
        if (file == null) {
            return false;
        }
        return file.isFile();
    }

    public boolean isReadable() throws IOException {
        if (!this.exists()) {
            return false;
        }
        if (Path.case()) {
            return this.do();
        }
        return this.if();
    }

    private boolean if() {
        File file = this.byte();
        if (file == null) {
            return false;
        }
        return file.canRead();
    }

    private boolean do() {
        File file = this.new();
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return false;
                }
            });
            return stringArray != null;
        }
        if (file.isFile()) {
            if (!file.canRead()) {
                return false;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                IoCloser.close(fileInputStream);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return file.canRead();
    }

    public boolean isWritable() throws IOException {
        if (!this.exists()) {
            return false;
        }
        File file = this.toJavaFile();
        if (file == null) {
            return false;
        }
        return file.canWrite();
    }

    public long getSize() throws IOException {
        this.try();
        File file = this.toJavaFile();
        if (file.isDirectory()) {
            return -1L;
        }
        return file.length();
    }

    public long getLastModifiedTime() throws IOException {
        this.try();
        File file = this.toJavaFile();
        return file.lastModified();
    }

    public Path[] list() throws IOException {
        this.try();
        if (!this.isDirectory()) {
            throw new DirectoryNotFoundException(this.do);
        }
        Object[] objectArray = Path.case() ? this.a() : this.int();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private Path[] a() throws IOException {
        if (this.else()) {
            return new Path[0];
        }
        Path[] pathArray = this.int();
        if (this.do.equals("/")) {
            Hashtable<Path, Object> hashtable = new Hashtable<Path, Object>();
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                hashtable.put(pathArray[n2], if);
                ++n2;
            }
            File[] fileArray = File.listRoots();
            if (fileArray == null) {
                throw new IOException("can't list FS roots");
            }
            n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                hashtable.put(Path.a(fileArray[n3]), if);
                ++n3;
            }
            n = hashtable.size();
            pathArray = new Path[n];
            Enumeration enumeration = hashtable.keys();
            int n4 = 0;
            while (n4 < n) {
                pathArray[n4] = (Path)enumeration.nextElement();
                ++n4;
            }
        }
        return pathArray;
    }

    private Path[] int() throws IOException {
        File file = this.toJavaFile();
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException(this.do + " is not a readable directory");
        }
        int n = stringArray.length;
        Path[] pathArray = new Path[n];
        int n2 = 0;
        while (n2 < n) {
            pathArray[n2] = new Path(this.do + '/' + stringArray[n2]);
            ++n2;
        }
        return pathArray;
    }

    public void createAsFile(boolean bl) throws IOException {
        Path path = this.getParentDirectory();
        if (bl) {
            path.toJavaFile().mkdirs();
        }
        if (!path.exists()) {
            throw new IOException("unable to create parent directories");
        }
        File file = this.toJavaFile();
        if (!file.createNewFile()) {
            throw new IOException("unable to create file " + this.do);
        }
    }

    public void createAsDirectory(boolean bl) throws IOException {
        File file = this.toJavaFile();
        boolean bl2 = bl ? file.mkdirs() : file.mkdir();
        if (!bl2 || !this.exists()) {
            throw new IOException("unable to create directory " + this.do);
        }
    }

    public void unlink() throws IOException {
        this.try();
        if (!this.toJavaFile().delete()) {
            throw new IOException("can't unlink file " + this.do);
        }
    }

    public void setLastModifiedTime(long l) throws IOException {
        this.try();
        boolean bl = this.toJavaFile().setLastModified(l);
        if (!bl) {
            throw new IOException("unable to set modified time for file " + this.do);
        }
    }

    public void move(Path path) throws IOException {
        this.try();
        if (Path.case()) {
            Path.a(this, path);
        } else {
            this.a(path);
        }
    }

    private static void a(Path path, Path path2) throws IOException {
        path = path.toAbsolutePath();
        path2 = path2.toAbsolutePath();
        File file = path.toJavaFile();
        File file2 = path2.toJavaFile();
        if (!path2.exists()) {
            if (file2.exists()) {
                throw new IOException("case conflict in dest");
            }
            Path path3 = path2.getParentDirectory();
            if (!path3.exists()) {
                throw new IOException("parent directory does not exist");
            }
        } else if (file2.isDirectory()) {
            path2 = new Path(path2, path.getFileName(), 2);
            file2 = path2.toJavaFile();
            if (!path2.exists()) {
                if (file2.exists()) {
                    throw new IOException("case conflict in dest");
                }
            } else {
                if (file2.isDirectory()) {
                    throw new IOException("can't replace directory");
                }
                if (!file2.delete()) {
                    throw new IOException("unable to replace dest");
                }
            }
        } else if (!file2.delete()) {
            throw new IOException("unable to replace dest");
        }
        if (!file.renameTo(file2)) {
            throw new IOException("move failed");
        }
    }

    private void a(Path path) throws IOException {
        if (!this.byte().renameTo(path.byte())) {
            throw new IOException("move failed");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        return this.do.equals(((Path)object).do);
    }

    public int hashCode() {
        return ~this.do.hashCode();
    }

    public String toString() {
        return this.do;
    }

    public int compareTo(Object object) {
        return this.do.compareTo(((Path)object).do);
    }

    public Path adjustCase() {
        if (!Path.case()) {
            return this;
        }
        try {
            String string = this.toJavaFile().getCanonicalPath().replace('\\', '/');
            String string2 = StringToolbox.getCommonSuffix(string.toUpperCase(), this.do.toUpperCase());
            return new Path(this.do.substring(0, this.do.length() - string2.length()) + StringToolbox.right(string, string2.length()));
        }
        catch (IOException iOException) {
            return this;
        }
    }
}

