/*
 * Decompiled with CFR 0.152.
 */
package lava.string;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import lava.string.StringToolbox;

public class PathToolbox {
    public static String simplifyPath(String string) {
        CharSequence charSequence;
        String[] stringArray = StringToolbox.splitString(string, "/");
        Stack<CharSequence> stack = new Stack<CharSequence>();
        if (string.startsWith("/")) {
            stack.push("");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            charSequence = stringArray[n2];
            if (!((String)charSequence).equals(".")) {
                if (((String)charSequence).equals("..")) {
                    if (stack.isEmpty()) {
                        stack.push("..");
                    } else {
                        Object e = stack.peek();
                        if (e != "") {
                            if (e == "..") {
                                stack.push("..");
                            } else {
                                stack.pop();
                            }
                        }
                    }
                } else {
                    stack.push(charSequence);
                }
            }
            ++n2;
        }
        charSequence = new StringBuffer();
        n = stack.size();
        if (n == 0) {
            return ".";
        }
        ((StringBuffer)charSequence).append(stack.firstElement());
        int n3 = 1;
        while (n3 < n) {
            ((StringBuffer)charSequence).append('/').append(stack.elementAt(n3));
            ++n3;
        }
        if (((StringBuffer)charSequence).length() == 0) {
            return "/";
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String getParentPath(String string) {
        return PathToolbox.simplifyPath(string + "/..");
    }

    public static String getFilename(String string) {
        if (string.length() == 0) {
            return string;
        }
        if ((string = StringToolbox.trim(string, '/')).equals("")) {
            return "/";
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static boolean isAbsolutePath(String string) {
        return string.startsWith("/");
    }

    public static boolean isRelativePath(String string) {
        return !PathToolbox.isAbsolutePath(string);
    }

    public static String concatenatePaths(String string, String string2) {
        String string3 = string + '/' + string2;
        String[] stringArray = StringToolbox.splitString(string3, "/");
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        if (PathToolbox.isAbsolutePath(string)) {
            stringBuffer.append('/');
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String resolveRelativePath(String string, String string2) {
        if (PathToolbox.isAbsolutePath(string2)) {
            return string2;
        }
        return PathToolbox.concatenatePaths(string, string2);
    }

    public static String toRelativePath(String string, String string2) {
        string = PathToolbox.simplifyPath(string);
        if (PathToolbox.isRelativePath(string2 = PathToolbox.simplifyPath(string2))) {
            return string2;
        }
        if (PathToolbox.isRelativePath(string)) {
            throw new IllegalArgumentException("from is relative: " + string);
        }
        String[] stringArray = StringToolbox.splitString(string, "/");
        String[] stringArray2 = StringToolbox.splitString(string2, "/");
        int n = 0;
        while (n < stringArray.length && n < stringArray2.length) {
            if (!stringArray[n].equals(stringArray2[n])) break;
            ++n;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = stringArray.length;
        while (n2 > n) {
            vector.addElement("..");
            --n2;
        }
        while (n2 < stringArray2.length) {
            vector.addElement(stringArray2[n2]);
            ++n2;
        }
        return PathToolbox.a(vector);
    }

    private static String a(Vector vector) {
        if (vector.isEmpty()) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append('/');
            } else {
                bl = true;
            }
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }
}

