/*
 * Decompiled with CFR 0.152.
 */
package lava.string;

import lava.text.html.HtmlEntities;

public class StringEncoder {
    public static String encodeAsciiJavaString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append('\"');
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    if (c > '\u007f' || Character.isISOControl(c)) {
                        stringBuffer.append(StringEncoder.a(c));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.append('\"').toString();
    }

    private static String a(int n) {
        return "\\u" + StringEncoder.charForDigit(n >> 12 & 0xF) + StringEncoder.charForDigit(n >> 8 & 0xF) + StringEncoder.charForDigit(n >> 4 & 0xF) + StringEncoder.charForDigit(n & 0xF);
    }

    public static String encodeHtmlText(String string) {
        return HtmlEntities.encodeHtmlText(string);
    }

    public static char charForDigit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n=" + n);
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        if (n < 36) {
            return (char)(65 + (n - 10));
        }
        throw new IllegalArgumentException("n=" + n);
    }

    public static String bytesToHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            stringBuffer.append(StringEncoder.charForDigit(n3 >> 4)).append(StringEncoder.charForDigit(n3 & 0xF));
            ++n2;
        }
        return stringBuffer.toString();
    }
}

