/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf;

import com.sharkysoft.printf.PrintfStringCharacterIterator;
import com.sharkysoft.printf.PrintfTemplateException;
import java.text.StringCharacterIterator;

final class FormatSpecifier {
    static final char JUSTIFICATION_RIGHT = '\u0000';
    static final char JUSTIFICATION_LEFT = '-';
    static final char JUSTIFICATION_CENTER = '^';
    static final char JUSTIFICATION_FULL = '0';
    static final char JUSTIFICATION_UNSPECIFIED = '\u0000';
    char mcJustification = '\u0000';
    static final char PREFIX_NONE = '\u0000';
    static final char PREFIX_PLUS = '+';
    static final char PREFIX_SPACE = ' ';
    static final char PREFIX_UNSPECIFIED = '\u0000';
    char mcPositivePrefix = '\u0000';
    static final char ALTERNATE_OFF = '\u0000';
    static final char ALTERNATE_ON = '#';
    static final char ALTERNATE_UNSPECIFIED = '\u0000';
    char mcAlternate = '\u0000';
    static final char PADCHAR_SPACE = ' ';
    static final char PADCHAR_ZERO = '0';
    static final char PADCHAR_UNSPECIFIED = ' ';
    char mcPadChar = (char)32;
    static final int WIDTH_DEFAULT = -2;
    static final int WIDTH_ARGUMENT = -1;
    static final int WIDTH_UNSPECIFIED = -2;
    int mnWidth = -2;
    static final int PRECISION_ANY = -2;
    static final int PRECISION_ARGUMENT = -1;
    static final int PRECISION_ZERO = 0;
    static final int PRECISION_UNSPECIFIED = -2;
    int mnPrecision = -2;
    static final char INPUT_SIZE_NORMAL = '\u0000';
    static final char INPUT_SIZE_SHORT = 'h';
    static final char INPUT_SIZE_LONG = 'l';
    static final char INPUT_SIZE_BYTE = 'b';
    static final char INPUT_SIZE_BIG = 'B';
    static final char INPUT_SIZE_UNSPECIFIED = '\u0000';
    char mcInputSize = '\u0000';
    static final char TYPE_SIGNED_DEC = 'd';
    static final char TYPE_UNSIGNED_DEC = 'u';
    static final char TYPE_OCT = 'o';
    static final char TYPE_HEX_LOWER = 'x';
    static final char TYPE_HEX_UPPER = 'X';
    static final char TYPE_FLOAT = 'f';
    static final char TYPE_FLOAT_E_LOWER = 'e';
    static final char TYPE_FLOAT_E_UPPER = 'E';
    static final char TYPE_FLOAT_G_LOWER = 'g';
    static final char TYPE_FLOAT_G_UPPER = 'G';
    static final char TYPE_CHAR = 'c';
    static final char TYPE_STRING = 's';
    static final char TYPE_PERCENT = '%';
    static final char TYPE_ENDL = '\n';
    static final char TYPE_CHARCOUNT = 'n';
    static final char TYPE_POINTER = 'p';
    static final char TYPE_INTEGER_UPPER = 'Z';
    static final char TYPE_INTEGER_LOWER = 'z';
    static final char TYPE_UNSPECIFIED = '\u0000';
    static final char TYPE_LITERAL = '\u0000';
    char mcType = '\u0000';
    int mnBase = 0;
    final String msLiteral;
    String msError = null;

    private void setError(String isError) {
        if (this.msError == null) {
            this.msError = isError;
        }
    }

    FormatSpecifier(StringCharacterIterator ipFs) {
        PrintfStringCharacterIterator vpFs = new PrintfStringCharacterIterator(ipFs);
        char vcC = vpFs.current();
        if (vcC != '%') {
            StringBuffer vpBuff = new StringBuffer();
            while (vcC != '\uffff' && vcC != '%') {
                vpBuff.append(vcC);
                vcC = vpFs.next();
            }
            this.msLiteral = vpBuff.toString();
            return;
        }
        vcC = vpFs.next();
        block26: while (true) {
            switch (vcC) {
                case '-': {
                    if (this.mcJustification != '\u0000') {
                        this.setError("multiple justifications");
                    }
                    this.mcJustification = (char)45;
                    break;
                }
                case '^': {
                    if (this.mcJustification != '\u0000') {
                        this.setError("multiple justifications");
                    }
                    this.mcJustification = (char)94;
                    break;
                }
                case '0': {
                    if (this.mcJustification != '\u0000') {
                        this.setError("multiple justifications");
                    }
                    this.mcPadChar = (char)48;
                    this.mcJustification = (char)48;
                    break;
                }
                case ' ': 
                case '+': {
                    if (this.mcPositivePrefix != '\u0000') {
                        this.setError("multiple positive prefixes");
                    }
                    this.mcPositivePrefix = vcC;
                    break;
                }
                case '#': {
                    if (this.mcAlternate != '\u0000') {
                        this.setError("alternate format selected twice");
                    }
                    this.mcAlternate = (char)35;
                    break;
                }
                default: {
                    break block26;
                }
            }
            vcC = vpFs.next();
        }
        switch (vcC) {
            case '*': {
                this.mnWidth = -1;
                vcC = vpFs.next();
                break;
            }
            default: {
                if (!FormatSpecifier.isdigit(vcC)) {
                    if (this.mcPadChar != ' ') {
                        this.setError("padding specified without field width");
                    }
                    if (this.mcJustification == '\u0000') break;
                    this.setError("justification specified without field width");
                    break;
                }
                int vnN = 0;
                do {
                    vnN = vnN * 10 + (vcC - 48);
                } while (FormatSpecifier.isdigit(vcC = vpFs.next()));
                this.mnWidth = vnN;
            }
        }
        if (vcC == '.') {
            vcC = vpFs.next();
            if (vcC == '\u0000') {
                this.mnPrecision = 0;
                vcC = vpFs.next();
            } else if (FormatSpecifier.isdigit(vcC)) {
                int n = 0;
                do {
                    n = n * 10 + (vcC - 48);
                } while (FormatSpecifier.isdigit(vcC = vpFs.next()));
                this.mnPrecision = n;
            } else if (vcC == '*') {
                this.mnPrecision = -1;
                vcC = vpFs.next();
            } else {
                this.setError("invalid precision specifier");
            }
        }
        switch (vcC) {
            case 'B': 
            case 'b': 
            case 'h': 
            case 'l': {
                this.mcInputSize = vcC;
                vcC = vpFs.next();
            }
        }
        this.mcType = vcC;
        if (this.mcType == 'i') {
            this.mcType = (char)100;
        }
        switch (this.mcType) {
            case 'u': {
                this.disallowPositivePrefix();
                this.disallowAlternateFormat();
                break;
            }
            case 'd': {
                this.disallowAlternateFormat();
                break;
            }
            case 'c': {
                this.disallowPrecision();
                this.disallowPositivePrefix();
                this.disallowFullJustification();
                break;
            }
            case 's': {
                this.disallowAlternateFormat();
                this.disallowPositivePrefix();
                this.disallowFullJustification();
                break;
            }
            case 'p': {
                this.disallowAlternateFormat();
                this.disallowPositivePrefix();
                break;
            }
            case 'Z': 
            case 'z': {
                this.disallowPositivePrefix();
                this.disallowAlternateFormat();
                if (vpFs.next() != '[') {
                    this.setError("'" + this.mcType + "' not followed by '['");
                    break;
                }
                StringBuffer digits = new StringBuffer();
                while ((vcC = vpFs.next()) != ']') {
                    if (vcC < '0' || '9' < vcC) {
                        throw new PrintfTemplateException("illegal base characters for '" + this.mcType + "[]'");
                    }
                    digits.append(vcC);
                }
                if (digits.length() == 0) {
                    throw new PrintfTemplateException("empty base for '" + this.mcType + "[]'");
                }
                this.mnBase = Integer.parseInt(digits.toString());
                if (this.mnBase < 2 || this.mnBase > 36) {
                    throw new PrintfTemplateException("illegal base for " + this.mcType + "[]: " + this.mnBase);
                }
            }
            case 'X': 
            case 'x': {
                this.disallowPositivePrefix();
                break;
            }
            case 'o': {
                this.disallowPositivePrefix();
                break;
            }
            case 'E': 
            case 'G': 
            case 'e': 
            case 'f': 
            case 'g': {
                this.disallow_short_size();
                break;
            }
            case '\n': 
            case '%': 
            case 'n': {
                this.disallow_size();
                this.disallowAlternateFormat();
                this.disallowPositivePrefix();
                this.disallowWidth();
                this.disallowPrecision();
                break;
            }
            default: {
                this.setError("conversion type character missing or invalid");
            }
        }
        vpFs.next();
        this.msLiteral = vpFs.getSubstring();
        if (this.msError != null) {
            throw new PrintfTemplateException("invalid format specifier: \"" + this.msLiteral + "\" (" + this.msError + ")");
        }
    }

    private void disallow_size() {
        if (this.mcInputSize != '\u0000') {
            this.setError("input size not allowed for %" + this.mcType);
        }
    }

    private void disallow_short_size() {
        switch (this.mcInputSize) {
            case 'b': 
            case 'h': {
                this.setError("short or byte input size not allowed for %" + this.mcType);
            }
        }
    }

    private void disallowAlternateFormat() {
        if (this.mcAlternate != '\u0000') {
            this.setError("alternate format not allowed for %" + this.mcType);
        }
    }

    private void disallowPositivePrefix() {
        if (this.mcPositivePrefix != '\u0000') {
            this.setError("positive prefix not allowed for %" + this.mcType);
        }
    }

    private void disallowFullJustification() {
        if (this.mcJustification == '0') {
            this.setError("full justification not allowed for %" + this.mcType);
        }
    }

    private void disallowWidth() {
        if (this.mnWidth != -2) {
            this.setError("field width not allowed for %" + this.mcType);
        }
    }

    private void disallowPrecision() {
        if (this.mnPrecision != -2) {
            this.setError("mnPrecision not allowed for %" + this.mcType);
        }
    }

    private void disallowType() {
        this.setError("sorry, %" + this.mcType + " not supported");
    }

    private String toNormalizedString() {
        StringBuffer s = new StringBuffer("%");
        if (this.mcJustification != '\u0000') {
            s.append(this.mcJustification);
        }
        if (this.mcPadChar != ' ') {
            s.append(this.mcPadChar);
        }
        if (this.mcAlternate != '\u0000') {
            s.append(this.mcAlternate);
        }
        if (this.mnWidth != -2) {
            if (this.mnWidth == -1) {
                s.append('*');
            } else {
                s.append(this.mnWidth);
            }
        }
        if (this.mnPrecision != -2) {
            s.append('.');
            if (this.mnPrecision == -1) {
                s.append('*');
            } else {
                s.append(this.mnPrecision);
            }
        }
        if (this.mcInputSize != '\u0000') {
            s.append(this.mcInputSize);
        }
        switch (this.mcType) {
            case '\n': {
                s.append("\\n");
                break;
            }
            default: {
                s.append(this.mcType);
            }
        }
        switch (this.mcType) {
            case 'Z': 
            case 'z': {
                s.append("[" + this.mnBase + "]");
            }
        }
        return s.toString();
    }

    public String toString() {
        return this.msLiteral;
    }

    static boolean isdigit(int inC) {
        return Character.isDigit((char)inC);
    }
}

