/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf;

import com.sharkysoft.math.MathToolbox;
import com.sharkysoft.printf.FormatSpecifier;
import com.sharkysoft.printf.Formatter_Number;
import com.sharkysoft.printf.PrintfState;
import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.printf.engine.RealFormatter;
import java.math.BigDecimal;

abstract class Formatter_Real
extends Formatter_Number {
    protected Formatter_Real(FormatSpecifier ipPfs) {
        super(ipPfs, new RealFormatter());
        RealFormatter rf = (RealFormatter)this.mpFormatter;
        switch (ipPfs.mnPrecision) {
            case -2: {
                rf.setMinRightDigits(6);
                rf.setMaxRightDigits(6);
                break;
            }
            case -1: {
                break;
            }
            default: {
                rf.setMinRightDigits(ipPfs.mnPrecision);
                rf.setMaxRightDigits(ipPfs.mnPrecision);
            }
        }
        if (ipPfs.mcPositivePrefix != '\u0000') {
            NumberFormatter nf = (NumberFormatter)this.mpFormatter;
            String vsPrefix = String.valueOf(ipPfs.mcPositivePrefix);
            nf.setZeroPrefix(vsPrefix);
            nf.setPosPrefix(vsPrefix);
        }
        if (ipPfs.mcAlternate == '#') {
            rf.setShowDecPoint(true);
        }
    }

    void adjustWidthAndPrecision(PrintfState ipPs) {
        this.adjustWidth(ipPs);
        this.adjustPrecision(ipPs);
    }

    void adjustPrecision(PrintfState ipPs) {
        if (this.mzVariablePrecision) {
            RealFormatter vpRf = (RealFormatter)this.mpFormatter;
            int vnRightDigits = ((Number)ipPs.mapArgs[ipPs.mnArgIndex++]).intValue();
            vpRf.setMinRightDigits(vnRightDigits);
            vpRf.setMaxRightDigits(vnRightDigits);
        }
    }

    void formatFloat(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format(((Number)ipPs.mapArgs[ipPs.mnArgIndex++]).floatValue()));
    }

    void formatDouble(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format(((Number)ipPs.mapArgs[ipPs.mnArgIndex++]).doubleValue()));
    }

    void formatBigDecimal(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format((BigDecimal)ipPs.mapArgs[ipPs.mnArgIndex++]));
    }

    void formatFloatScientific(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format(MathToolbox.toScientificNotation((float)((Number)ipPs.mapArgs[ipPs.mnArgIndex++]).floatValue())));
    }

    void formatDoubleScientific(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format(MathToolbox.toScientificNotation((double)((Number)ipPs.mapArgs[ipPs.mnArgIndex++]).doubleValue())));
    }

    void formatBigDecimalScientific(PrintfState ipPs) {
        ipPs.mpOutput.append(((RealFormatter)this.mpFormatter).format(MathToolbox.toScientificNotation((BigDecimal)((BigDecimal)ipPs.mapArgs[ipPs.mnArgIndex++]))));
    }
}

