/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf;

import com.sharkysoft.printf.FormatSpecifier;
import com.sharkysoft.printf.Formatter_Field;
import com.sharkysoft.printf.PrintfState;
import com.sharkysoft.printf.engine.IntegerFormatter;
import com.sharkysoft.printf.engine.StringFormatter;
import com.sharkysoft.util.NotImplementedException;

final class Formatter_c
extends Formatter_Field {
    private static final IntegerFormatter gpUnicodeFmt = new IntegerFormatter();
    private static final IntegerFormatter gpAsciiFmt = new IntegerFormatter();
    private final boolean mzAlternate;

    Formatter_c(FormatSpecifier mpPfs) {
        super(mpPfs, new StringFormatter());
        this.mzAlternate = mpPfs.mcAlternate == '#';
    }

    void format(PrintfState ipState) {
        String vsOutput;
        this.adjustWidth(ipState);
        char vcC = ((Character)ipState.mapArgs[ipState.mnArgIndex++]).charValue();
        if (this.mzAlternate) {
            switch (vcC) {
                case '\"': {
                    vsOutput = "\\\"";
                    break;
                }
                case '\'': {
                    vsOutput = "\\'";
                    break;
                }
                case '\n': {
                    vsOutput = "\\n";
                    break;
                }
                case '\r': {
                    vsOutput = "\\r";
                    break;
                }
                case '\b': {
                    vsOutput = "\\b";
                    break;
                }
                case '\t': {
                    vsOutput = "\\t";
                    break;
                }
                case '\f': {
                    vsOutput = "\\f";
                    break;
                }
                default: {
                    if (Formatter_c.isprint(vcC)) {
                        vsOutput = "" + vcC;
                        break;
                    }
                    if (vcC < '\u0100') {
                        vsOutput = gpAsciiFmt.format(vcC);
                        break;
                    }
                    vsOutput = gpUnicodeFmt.format(vcC);
                    break;
                }
            }
        } else {
            vsOutput = "" + vcC;
        }
        ipState.mpOutput.append(this.mpFormatter.format(vsOutput));
    }

    final int argsRequired() {
        return 1 + (this.mzVariableWidth ? 1 : 0);
    }

    static boolean isprint(int c) {
        if (c > 255) {
            throw new NotImplementedException("c=" + c);
        }
        return 32 <= c && c <= 126;
    }

    static {
        gpUnicodeFmt.setMinDigits(4);
        gpUnicodeFmt.setRadix(16);
        gpUnicodeFmt.setZeroPrefix("\\u");
        gpUnicodeFmt.setPosPrefix("\\u");
        gpAsciiFmt.setMinDigits(3);
        gpAsciiFmt.setRadix(8);
        gpAsciiFmt.setZeroPrefix("\\");
        gpAsciiFmt.setPosPrefix("\\");
    }
}

