/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf.engine;

import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.string.StringToolbox;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegerFormatter
extends NumberFormatter {
    protected char mcPadDigit = (char)48;
    protected int mnMinDigits = 1;
    private static final BigInteger LONG_NEG_ADJUSTMENT = new BigInteger("ffffffffffffffff", 16).not();

    public char getPadDigit() {
        return this.mcPadDigit;
    }

    public void setPadDigit(char icPadDigit) {
        this.mcPadDigit = icPadDigit;
    }

    public int getMinDigits() {
        return this.mnMinDigits;
    }

    public void setMinDigits(int inMinDigits) {
        if (inMinDigits < 0) {
            throw new IllegalArgumentException("inMinDigits=" + inMinDigits);
        }
        this.mnMinDigits = inMinDigits;
    }

    /*
     * WARNING - void declaration
     */
    public String format(BigInteger ipValue) {
        void var2_2;
        void var4_6;
        int vsExtra;
        String vsDigits;
        if (this.mnSigDigits > 0) {
            ipValue = IntegerFormatter.setSignificantDigits(new BigDecimal(ipValue), this.mnSigDigits).toBigInteger();
        }
        switch (ipValue.signum()) {
            case 1: {
                String vsPrefix = this.msPosPrefix;
                String vsSuffix = this.msPosSuffix;
                vsDigits = ipValue.toString(this.mnRadix);
                break;
            }
            case 0: {
                String vsPrefix = this.msZeroPrefix;
                String vsSuffix = this.msZeroSuffix;
                vsDigits = this.mnMinDigits > 0 ? "0" : "";
                break;
            }
            case -1: {
                String vsPrefix = this.msNegPrefix;
                String vsSuffix = this.msNegSuffix;
                vsDigits = ipValue.negate().toString(this.mnRadix);
                break;
            }
            default: {
                throw new RuntimeException("unreachable code");
            }
        }
        if (this.mzUpperCase) {
            vsDigits = vsDigits.toUpperCase();
        }
        String vsExtender = (vsExtra = this.mnMinDigits - var4_6.length()) > 0 ? (this.mcPadDigit != '\u0000' ? StringToolbox.repeat((char)this.mcPadDigit, (int)vsExtra) : StringToolbox.repeat((char)' ', (int)vsExtra)) : "";
        StringBuffer vsLeftSide = new StringBuffer();
        StringBuffer vsRightSide = new StringBuffer();
        if (this.mnAlignment == 4) {
            vsLeftSide.append((String)var2_2);
            vsRightSide.append(vsExtender);
        } else if (this.mcPadDigit != '\u0000') {
            vsRightSide.append((String)var2_2);
            vsRightSide.append(vsExtender);
        } else {
            vsRightSide.append(vsExtender);
            vsRightSide.append((String)var2_2);
        }
        vsRightSide.append((String)var4_6);
        return this.format(vsLeftSide.toString(), vsRightSide.toString());
    }

    public final String format(long ilValue) {
        return this.format(BigInteger.valueOf(ilValue));
    }

    public final String format(int inValue) {
        return this.format(BigInteger.valueOf(inValue));
    }

    public final String formatUnsigned(long ilValue) {
        BigInteger vpBig = BigInteger.valueOf(ilValue);
        if (ilValue < 0L) {
            vpBig = vpBig.xor(LONG_NEG_ADJUSTMENT);
        }
        return this.format(vpBig);
    }

    public final String formatUnsigned(int inValue) {
        return this.format(BigInteger.valueOf((long)inValue & 0xFFFFFFFFL));
    }

    public final String formatUnsigned(short iwValue) {
        return this.format(BigInteger.valueOf((long)iwValue & 0xFFFFL));
    }

    public final String formatUnsigned(byte ibValue) {
        return this.format(BigInteger.valueOf((long)ibValue & 0xFFL));
    }
}

