/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf.engine;

import com.sharkysoft.math.MantissaExponent;
import com.sharkysoft.printf.engine.IntegerFormatter;
import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.string.StringToolbox;
import com.sharkysoft.util.UnreachableCodeException;
import java.math.BigDecimal;

public class RealFormatter
extends NumberFormatter {
    protected final IntegerFormatter mpExponentFormatter = new IntegerFormatter();
    protected int mnMaxLeftDigits = Integer.MAX_VALUE;
    protected int mnMinLeftDigits = 1;
    protected char mcLeftPadDigit = (char)48;
    protected boolean mzShowDecPoint = false;
    protected int mnMinRightDigits = 0;
    protected char mcRightPadDigit = (char)48;
    protected int mnMaxRightDigits = Integer.MAX_VALUE;

    public IntegerFormatter getExponentFormatter() {
        return this.mpExponentFormatter;
    }

    public int getMaxLeftDigits() {
        return this.mnMaxLeftDigits;
    }

    public void setMaxLeftDigits(int inMaxLeftDigits) {
        if (inMaxLeftDigits < 0) {
            throw new IllegalArgumentException("inMaxLeftDigits=" + inMaxLeftDigits);
        }
        if (inMaxLeftDigits < this.mnMinLeftDigits) {
            this.mnMinLeftDigits = inMaxLeftDigits;
        }
        this.mnMaxLeftDigits = inMaxLeftDigits;
    }

    public int getMinLeftDigits() {
        return this.mnMinLeftDigits;
    }

    public void setMinLeftDigits(int inMinLeftDigits) {
        if (inMinLeftDigits < 0) {
            throw new IllegalArgumentException("inMinLeftDigits=" + inMinLeftDigits);
        }
        if (inMinLeftDigits > this.mnMaxLeftDigits) {
            this.mnMaxLeftDigits = inMinLeftDigits;
        }
        this.mnMinLeftDigits = inMinLeftDigits;
    }

    public char getLeftPadDigit() {
        return this.mcLeftPadDigit;
    }

    public void setLeftPadDigit(char icLeftPadDigit) {
        this.mcLeftPadDigit = icLeftPadDigit;
    }

    public boolean getShowDecPoint() {
        return this.mzShowDecPoint;
    }

    public void setShowDecPoint(boolean izShowDecPoint) {
        this.mzShowDecPoint = izShowDecPoint;
    }

    public int getMinRightDigits() {
        return this.mnMinRightDigits;
    }

    public void setMinRightDigits(int inMinRightDigits) {
        if (inMinRightDigits < 0) {
            throw new IllegalArgumentException("inMinRightDigits=" + inMinRightDigits);
        }
        if (inMinRightDigits > this.mnMaxRightDigits) {
            this.mnMaxRightDigits = inMinRightDigits;
        }
        this.mnMinRightDigits = inMinRightDigits;
    }

    public char getRightPadDigit() {
        return this.mcRightPadDigit;
    }

    public void setRightPadDigit(char icRightPadDigit) {
        this.mcRightPadDigit = icRightPadDigit;
    }

    public int getMaxRightDigits() {
        return this.mnMaxRightDigits;
    }

    public void setMaxRightDigits(int inMaxRightDigits) {
        if (inMaxRightDigits < 0) {
            throw new IllegalArgumentException("inMaxRightDigits=" + inMaxRightDigits);
        }
        if (inMaxRightDigits < this.mnMinRightDigits) {
            this.mnMinRightDigits = inMaxRightDigits;
        }
        this.mnMaxRightDigits = inMaxRightDigits;
    }

    public RealFormatter() {
        this.mpExponentFormatter.msZeroPrefix = "E";
        this.mpExponentFormatter.msNegPrefix = "E-";
        this.mpExponentFormatter.msPosPrefix = "E+";
        this.mpExponentFormatter.mnMinDigits = 2;
    }

    /*
     * WARNING - void declaration
     */
    private final String format(BigDecimal ipValue, String isExponentSuffix) {
        void var4_4;
        void var3_3;
        String vsRightExtender;
        int vnExtra;
        String vsRightDigits;
        String vsLeftDigits;
        String vsString;
        if (this.mnRadix != 10) {
            throw new IllegalArgumentException("mnRadix=" + this.mnRadix);
        }
        switch (ipValue.signum()) {
            case -1: {
                String vsPrefix = this.msNegPrefix;
                String vsSuffix = this.msNegSuffix;
                ipValue = ipValue.negate();
                break;
            }
            case 0: {
                String vsPrefix = this.msZeroPrefix;
                String vsSuffix = this.msZeroSuffix;
                break;
            }
            case 1: {
                String vsPrefix = this.msPosPrefix;
                String vsSuffix = this.msPosSuffix;
                break;
            }
            default: {
                throw new UnreachableCodeException();
            }
        }
        if (this.mnSigDigits > 0) {
            int vnTrimAmt = (ipValue = RealFormatter.setSignificantDigits(ipValue, this.mnSigDigits)).scale() - this.mnMaxRightDigits;
            if (vnTrimAmt > 0) {
                StringBuffer vpBuff = new StringBuffer(ipValue.toString());
                int vnLast = vpBuff.length() - 1;
                for (int vnI = 0; vnI < vnTrimAmt && vpBuff.charAt(vnLast) == '0'; ++vnI) {
                    --vnLast;
                }
                vpBuff.setLength(vnLast + 1);
                vsString = vpBuff.toString();
            } else {
                vsString = ipValue.toString();
            }
        } else {
            if (ipValue.scale() > this.mnMaxRightDigits) {
                ipValue = ipValue.setScale(this.mnMaxRightDigits, 4);
            }
            vsString = ipValue.toString();
        }
        int vnDpPos = vsString.indexOf(46);
        if (vnDpPos == -1) {
            vsLeftDigits = vsString;
            vsRightDigits = "";
        } else {
            int vnLds = vnDpPos - this.mnMaxLeftDigits;
            if (vnLds < 0) {
                vnLds = 0;
            }
            vsLeftDigits = vsString.substring(vnLds, vnDpPos);
            vsRightDigits = ++vnDpPos == vsString.length() ? "" : vsString.substring(vnDpPos);
        }
        int vnExtra2 = this.mnMinLeftDigits - vsLeftDigits.length();
        String vsLeftExtender = vnExtra2 > 0 ? (this.mcLeftPadDigit != '\u0000' ? StringToolbox.repeat((char)this.mcLeftPadDigit, (int)vnExtra2) : StringToolbox.repeat((char)' ', (int)vnExtra2)) : "";
        boolean vzNeedDecPoint = this.mzShowDecPoint;
        int vnLength = vsRightDigits.length();
        if (vnLength > 0) {
            vzNeedDecPoint = true;
        }
        if ((vnExtra = this.mnMinRightDigits - vsRightDigits.length()) > 0) {
            if (this.mcRightPadDigit != '\u0000') {
                vsRightExtender = StringToolbox.repeat((char)this.mcRightPadDigit, (int)vnExtra);
                if (this.mcRightPadDigit != ' ') {
                    vzNeedDecPoint = true;
                }
            } else {
                vsRightExtender = StringToolbox.repeat((char)' ', (int)vnExtra);
            }
        } else {
            vsRightExtender = "";
        }
        StringBuffer vpLeftSide = new StringBuffer();
        StringBuffer vpRightSide = new StringBuffer();
        if (this.mnAlignment == 4) {
            vpLeftSide.append((String)var3_3);
            vpRightSide.append(vsLeftExtender);
        } else if (this.mcLeftPadDigit != '\u0000') {
            vpRightSide.append((String)var3_3);
            vpRightSide.append(vsLeftExtender);
        } else {
            vpRightSide.append(vsLeftExtender);
            vpRightSide.append((String)var3_3);
        }
        vpRightSide.append(vsLeftDigits);
        if (vzNeedDecPoint) {
            vpRightSide.append('.');
        }
        vpRightSide.append(vsRightDigits);
        if (this.mcRightPadDigit != '\u0000') {
            vpRightSide.append(vsRightExtender);
            vpRightSide.append(isExponentSuffix).append((String)var4_4);
        } else {
            vpRightSide.append(isExponentSuffix).append((String)var4_4);
            vpRightSide.append(vsRightExtender);
        }
        return this.format(vpLeftSide.toString(), vpRightSide.toString());
    }

    public final String format(MantissaExponent ipValue) {
        BigDecimal vpMantissa = ipValue.getMantissa();
        if (vpMantissa == null) {
            switch (ipValue.getExponent()) {
                case 0: {
                    return this.formatSpecial(this.msPosPrefix + "nan");
                }
                case -1: {
                    return this.formatSpecial(this.msNegPrefix + "inf");
                }
                case 1: {
                    return this.formatSpecial(this.msZeroPrefix + "inf");
                }
            }
            throw new UnreachableCodeException("getExponent returned spurious value");
        }
        return this.format(vpMantissa, this.mpExponentFormatter.format(ipValue.getExponent()));
    }

    public final String format(BigDecimal ipValue) {
        return this.format(ipValue, "");
    }

    private String formatSpecial(String isSpecial) {
        switch (this.mnAlignment) {
            case 4: {
                return this.format("", isSpecial, ' ');
            }
        }
        return this.format(isSpecial, ' ');
    }

    public final String format(float ifValue) {
        if (ifValue == Float.NEGATIVE_INFINITY) {
            return this.formatSpecial(this.msNegPrefix + "inf");
        }
        if (ifValue == Float.POSITIVE_INFINITY) {
            return this.formatSpecial(this.msPosPrefix + "inf");
        }
        if (Float.isNaN(ifValue)) {
            return this.formatSpecial(this.msZeroPrefix + "nan");
        }
        return this.format(new BigDecimal(ifValue));
    }

    public final String format(double idValue) {
        if (idValue == Double.NEGATIVE_INFINITY) {
            return this.formatSpecial(this.msNegPrefix + "inf");
        }
        if (idValue == Double.POSITIVE_INFINITY) {
            return this.formatSpecial(this.msPosPrefix + "inf");
        }
        if (Double.isNaN(idValue)) {
            return this.formatSpecial(this.msZeroPrefix + "nan");
        }
        return this.format(new BigDecimal(idValue));
    }
}

