/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.printf.engine;

import com.sharkysoft.printf.engine.AlignmentMode;
import com.sharkysoft.printf.engine.CroppingMode;
import com.sharkysoft.string.StringToolbox;
import com.sharkysoft.util.UnreachableCodeException;

public class StringFormatter {
    protected int mnFieldWidth = 0;
    protected int mnAlignment = 1;
    protected char mcPadChar = (char)32;
    protected int mnCropping = 0;

    public int getFieldWidth() {
        return this.mnFieldWidth;
    }

    public void setFieldWidth(int inFieldWidth) {
        if (inFieldWidth < 0) {
            throw new IllegalArgumentException("inFieldWidth=" + inFieldWidth);
        }
        this.mnFieldWidth = inFieldWidth;
    }

    public AlignmentMode getAlignment() {
        return AlignmentMode.forInt(this.mnAlignment);
    }

    public void setAlignment(AlignmentMode ipAlignment) {
        this.mnAlignment = ipAlignment.toInt();
    }

    public char getPadChar() {
        return this.mcPadChar;
    }

    public void setPadChar(char icPadChar) {
        this.mcPadChar = icPadChar;
    }

    public CroppingMode getCropping() {
        return CroppingMode.forInt(this.mnCropping);
    }

    public void setCropping(CroppingMode ipCropping) {
        this.mnCropping = ipCropping.toInt();
    }

    private final String crop(String isText) {
        int vnPadSize = this.mnFieldWidth - isText.length();
        if (vnPadSize <= 0) {
            switch (this.mnCropping) {
                case 0: {
                    return isText;
                }
                case 2: {
                    return isText.substring(-vnPadSize);
                }
                case 1: {
                    return isText.substring(0, this.mnFieldWidth);
                }
                case 3: {
                    return isText.substring(-vnPadSize / 2, -vnPadSize / 2 + this.mnFieldWidth);
                }
            }
            throw new UnreachableCodeException();
        }
        return isText;
    }

    public final String format(String isText) {
        return this.format(isText, this.mcPadChar);
    }

    final String format(String isText, char icPad) {
        int vnPadSize = this.mnFieldWidth - isText.length();
        if (vnPadSize <= 0) {
            return this.crop(isText);
        }
        String vsPadding = StringToolbox.repeat((char)icPad, (int)vnPadSize);
        switch (this.mnAlignment) {
            case 3: {
                return vsPadding + isText;
            }
            case 1: {
                return isText + vsPadding;
            }
            case 2: {
                return vsPadding.substring(0, vnPadSize /= 2) + isText + vsPadding.substring(vnPadSize);
            }
            case 4: {
                throw new UnsupportedOperationException("full justification");
            }
        }
        throw new UnreachableCodeException();
    }

    public final String format(String isPrefix, String isSuffix) {
        return this.format(isPrefix, isSuffix, this.mcPadChar);
    }

    final String format(String isPrefix, String isSuffix, char icPad) {
        if (this.mnAlignment != 4) {
            return this.format(isPrefix + isSuffix, icPad);
        }
        int vnPadSize = this.mnFieldWidth - (isPrefix.length() + isSuffix.length());
        if (vnPadSize <= 0) {
            return this.crop(isPrefix + isSuffix);
        }
        String vsPadding = StringToolbox.repeat((char)icPad, (int)vnPadSize);
        return isPrefix + vsPadding + isSuffix;
    }

    public String toString() {
        return "StringFormatter {FieldWidth: " + this.mnFieldWidth + ", Alignment: " + AlignmentMode.toString((int)this.mnAlignment) + ", PadChar: (char) " + this.mcPadChar + ", Cropping:" + CroppingMode.toString((int)this.mnCropping) + "}";
    }
}

