package com.sharkysoft.printf;

import java.math.BigInteger;
import com.sharkysoft.printf.engine.IntegerFormatter;

abstract class Formatter_Integer extends Formatter_Number
{

  Formatter_Integer(final FormatSpecifier ipPfs)
  {
    super(ipPfs, new IntegerFormatter());
    final IntegerFormatter vpFormatter = (IntegerFormatter) mpFormatter;
    if (ipPfs.mnPrecision == FormatSpecifier.PRECISION_UNSPECIFIED)
      vpFormatter.setMinDigits(1);
    else
      vpFormatter.setMinDigits(ipPfs.mnPrecision);
  }
  
  void adjustWidthAndPrecision(final PrintfState ipPs)
  {
    adjustWidth(ipPs);
    if (mzVariablePrecision)
      ( (IntegerFormatter) mpFormatter
      ).setMinDigits
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue()
      );
  }

  void formatSignedInt(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue()
      )
    );
  }
  
  void formatSignedLong(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).longValue()
      )
    );
  }
  
  void formatSignedShort(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).shortValue()
      )
    );
  }
  
  void formatSignedByte(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).byteValue()
      )
    );
  }
  
  void formatSignedBigInteger(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).format
      ( (BigInteger) ipPs.mapArgs[ipPs.mnArgIndex++]
      )
    );
  }
  
  void formatUnsignedInt(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).formatUnsigned
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue()
      )
    );
  }
  
  void formatUnsignedLong(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).formatUnsigned
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).longValue()
      )
    );
  }
  
  void formatUnsignedShort(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).formatUnsigned
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).shortValue()
      )
    );
  }
  
  void formatUnsignedByte(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ( (IntegerFormatter) mpFormatter
      ).formatUnsigned
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).byteValue()
      )
    );
  }
  
  void formatUnsignedBigInteger(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    final BigInteger vpBi = (BigInteger) ipPs.mapArgs[ipPs.mnArgIndex++];
    ipPs.mpOutput.append(((IntegerFormatter) mpFormatter).format(vpBi));
  }

}

