package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.IntegerFormatter;
import com.sharkysoft.printf.engine.StringFormatter;

final class Formatter_c extends Formatter_Field
{

	private static final IntegerFormatter gpUnicodeFmt = new IntegerFormatter();

	private static final IntegerFormatter gpAsciiFmt = new IntegerFormatter();

	static 
	{
		gpUnicodeFmt.setMinDigits(4);
		gpUnicodeFmt.setRadix(16);
		gpUnicodeFmt.setZeroPrefix("\\u");
		gpUnicodeFmt.setPosPrefix("\\u");
		gpAsciiFmt.setMinDigits(3);
		gpAsciiFmt.setRadix(8);
		gpAsciiFmt.setZeroPrefix("\\");
		gpAsciiFmt.setPosPrefix("\\");
	}

	private final boolean mzAlternate;

	Formatter_c(final FormatSpecifier mpPfs)
	{
		super(mpPfs, new StringFormatter());
		mzAlternate = mpPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON;
	}

	void format(final PrintfState ipState)
	{
		adjustWidth(ipState);
		final char vcC = ((Character) ipState.mapArgs[ipState.mnArgIndex++]).charValue();
		final String vsOutput;
		if (mzAlternate)
			switch (vcC)
			{
			case '"' :
				vsOutput = "\\\"";
				break;
			case '\'' :
				vsOutput = "\\'";
				break;
			case '\n' :
				vsOutput = "\\n";
				break;
			case '\r' :
				vsOutput = "\\r";
				break;
			case '\b' :
				vsOutput = "\\b";
				break;
			case '\t' :
				vsOutput = "\\t";
				break;
			case '\f' :
				vsOutput = "\\f";
				break;
			default :
				if (isprint(vcC))
					vsOutput = "" + vcC;
				else if (vcC < 256)
					vsOutput = gpAsciiFmt.format((int) vcC);
				else
					vsOutput = gpUnicodeFmt.format((int) vcC);
			}
		else
			vsOutput = "" + vcC;
		ipState.mpOutput.append(mpFormatter.format(vsOutput));
	}

	final int argsRequired()
	{
		return 1 + (mzVariableWidth ? 1 : 0);
	}

	/**
	 * <p><b>Details:</b> Returns <code>true</code> if c is a printing character.  
	 * For ASCII values, c is a printing character if and only if c is in 
	 * {32..127}.  This method does not support Unicode values, but it may in the 
	 * future.
	 */
	static boolean isprint(int c)
	{
		if (c > 255)
			throw new com.sharkysoft.util.NotImplementedException("c=" + c);
		return 32 <= c && c <= 126;
	}

}

