package com.sharkysoft.printf;

import java.math.BigDecimal;
import com.sharkysoft.math.MathToolbox;

final class Formatter_g_Bi extends Formatter_g
{

  Formatter_g_Bi(final FormatSpecifier ipPfs)
  {
    super(ipPfs);
  }

  void format(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    if 
    ( shouldUseScientific
      ( MathToolbox.toScientificNotation
        ( ((BigDecimal) ipPs.mapArgs[ipPs.mnArgIndex]).doubleValue()
        )
      )
    )
      formatBigDecimalScientific(ipPs);
    else
      formatBigDecimal(ipPs);
  }

}

