package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.StringFormatter;

final class Formatter_s extends Formatter_Field
{

  final int mnPrecision;

  Formatter_s(final FormatSpecifier ipPfs)
  {
    super(ipPfs, new StringFormatter());
    mnPrecision = ipPfs.mnPrecision;
  }
  
  void format(final PrintfState ipPs)
  {
    adjustWidth(ipPs);
    int vnPrec = mnPrecision;
    if (vnPrec == FormatSpecifier.PRECISION_ARGUMENT)
    {
      vnPrec = ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue();
      if (vnPrec < 0)
        throw new PrintfTemplateException("variable precision=" + mnPrecision);
    }
    final Object vpO = ipPs.mapArgs[ipPs.mnArgIndex++];
    String vsS;
    if (vpO != null)
      vsS = vpO.toString();
    else
      vsS = "null";
    if (vnPrec >= 0)
    {
      if (vsS.length() > vnPrec)
        vsS = vsS.substring(0, mnPrecision);
    }
    ipPs.mpOutput.append(mpFormatter.format(vsS));
  }
  
  final int argsRequired()
  {
    return 1
      + (mnPrecision == FormatSpecifier.PRECISION_ARGUMENT ? 1 : 0)
      + (mzVariableWidth ? 1 : 0);
  }
  
}

