package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.util.UnreachableCodeException;

class Formatter_z extends Formatter_Integer
{

  Formatter_z(final FormatSpecifier ipPfs)
  {
    super(ipPfs);
    final NumberFormatter vpNf = (NumberFormatter) mpFormatter;
    vpNf.setRadix(ipPfs.mnBase);
    switch (ipPfs.mcType)
    {
    case 'z' :
      vpNf.setUpperCase(false);
      break;
    case 'Z' :
      vpNf.setUpperCase(true);
      break;
    default :
      throw new UnreachableCodeException();
    }
  }

  void format(final PrintfState ipPs)
  {
    formatUnsignedInt(ipPs);
  }
  
}

