package com.sharkysoft.printf;

import com.sharkysoft.util.UnreachableCodeException;

abstract class Formatter
{

  protected Formatter()
  {
  }

  abstract void format(PrintfState ipPs);

  abstract int argsRequired();
  
  private static final String LINE_SEPARATOR;
  
  static 
  {
    String vsLineSeparator = "\n";
    try
    {
      vsLineSeparator = System.getProperty("line.separator");
    }
    catch (SecurityException e)
    {
    }
    LINE_SEPARATOR = vsLineSeparator;
  }
  
  static Formatter create(FormatSpecifier ipPfs)
  {
    switch (ipPfs.mcType)
    {
    // These cases are presented in order of highest probability, in order to let the switch run as fast as possible.
    case FormatSpecifier.TYPE_LITERAL :
      return new Formatter_Literal(ipPfs.msLiteral);
    case FormatSpecifier.TYPE_SIGNED_DEC :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_d(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_d_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_SHORT :
        return new Formatter_d_h(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BYTE :
        return new Formatter_d_by(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_d_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_STRING :
      return new Formatter_s(ipPfs);
    case FormatSpecifier.TYPE_UNSIGNED_DEC :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_u(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_u_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_SHORT :
        return new Formatter_u_h(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BYTE :
        return new Formatter_u_By(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_u_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_HEX_LOWER :
    case FormatSpecifier.TYPE_HEX_UPPER :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_x(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_x_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_SHORT :
        return new Formatter_x_h(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BYTE :
        return new Formatter_x_By(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_x_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_INTEGER_UPPER :
    case FormatSpecifier.TYPE_INTEGER_LOWER :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_z(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_z_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_SHORT :
        return new Formatter_z_h(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BYTE :
        return new Formatter_z_by(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_z_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_OCT :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_o(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_o_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_SHORT :
        return new Formatter_o_h(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BYTE :
        return new Formatter_o_by(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_o_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_CHAR :
      return new Formatter_c(ipPfs);
    case FormatSpecifier.TYPE_FLOAT :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_f(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_f_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_f_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_FLOAT_E_LOWER :
    case FormatSpecifier.TYPE_FLOAT_E_UPPER :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_e(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_e_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_e_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_FLOAT_G_LOWER :
    case FormatSpecifier.TYPE_FLOAT_G_UPPER :
      switch (ipPfs.mcInputSize)
      {
      case FormatSpecifier.INPUT_SIZE_NORMAL :
        return new Formatter_g(ipPfs);
      case FormatSpecifier.INPUT_SIZE_LONG :
        return new Formatter_g_l(ipPfs);
      case FormatSpecifier.INPUT_SIZE_BIG :
        return new Formatter_g_Bi(ipPfs);
      }
      break;
    case FormatSpecifier.TYPE_POINTER :
      return new Formatter_p(ipPfs);
    case FormatSpecifier.TYPE_CHARCOUNT :
      return new Formatter_n(ipPfs);
    case FormatSpecifier.TYPE_PERCENT :
      return new Formatter_Literal("%");
    case FormatSpecifier.TYPE_ENDL :
      return new Formatter_Literal(LINE_SEPARATOR);
    }
    throw new UnreachableCodeException();
  }
}

