package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.AlignmentMode;
import com.sharkysoft.printf.engine.StringFormatter;
import com.sharkysoft.util.UnreachableCodeException;

abstract class Formatter_Field extends Formatter
{

  protected final StringFormatter mpFormatter;
  
  protected final boolean mzVariableWidth;
  
  Formatter_Field(final FormatSpecifier ipPfs, final StringFormatter ipSf)
  {
    super();
    mpFormatter = ipSf;
    switch (ipPfs.mnWidth)
    {
    case FormatSpecifier.WIDTH_ARGUMENT:
      mzVariableWidth = true;
      break;
    case FormatSpecifier.WIDTH_UNSPECIFIED:
      mzVariableWidth = false;
      break;
    default:
    	mzVariableWidth = false;
    	mpFormatter.setFieldWidth(ipPfs.mnWidth);    
    }
//    if (ipPfs.mnWidth == PrintfFormatSpecifier.WIDTH_ARGUMENT)
//      mzVariableWidth = true;
//    else
//    {
//      mzVariableWidth = false;
//      mpFormatter.setFieldWidth(ipPfs.mnWidth);
//    }
    switch (ipPfs.mcJustification)
    {
    case FormatSpecifier.JUSTIFICATION_RIGHT :
      mpFormatter.setAlignment(AlignmentMode.gpRight);
      break;
    case FormatSpecifier.JUSTIFICATION_LEFT :
      mpFormatter.setAlignment(AlignmentMode.gpLeft);
      break;
    case FormatSpecifier.JUSTIFICATION_CENTER :
      mpFormatter.setAlignment(AlignmentMode.gpCenter);
      break;
    case FormatSpecifier.JUSTIFICATION_FULL:
      mpFormatter.setAlignment(AlignmentMode.gpFull);
			if (ipPfs.mcPadChar == FormatSpecifier.PADCHAR_ZERO)
				mpFormatter.setPadChar('0');
      break;
    default :
      throw new UnreachableCodeException();
    }
  }

  protected final void adjustWidth(final PrintfState ipPs)
  {
    if (mzVariableWidth)
      mpFormatter.setFieldWidth(((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue());
  }
  
}

