package com.sharkysoft.printf;

import java.math.BigDecimal;
import com.sharkysoft.math.MathToolbox;
import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.printf.engine.RealFormatter;

abstract class Formatter_Real extends Formatter_Number
{

  protected Formatter_Real(final FormatSpecifier ipPfs)
  {
    super(ipPfs, new RealFormatter());
    final RealFormatter rf = (RealFormatter) mpFormatter;
    switch (ipPfs.mnPrecision)
    {
    case FormatSpecifier.PRECISION_UNSPECIFIED :
      rf.setMinRightDigits(6);
      rf.setMaxRightDigits(6);
      break;
    case FormatSpecifier.PRECISION_ARGUMENT :
      break;
    default :
      rf.setMinRightDigits(ipPfs.mnPrecision);
      rf.setMaxRightDigits(ipPfs.mnPrecision);
    }
    if (ipPfs.mcPositivePrefix != FormatSpecifier.PREFIX_UNSPECIFIED)
    {
      final NumberFormatter nf = (NumberFormatter) mpFormatter;
      final String vsPrefix = String.valueOf(ipPfs.mcPositivePrefix);
      nf.setZeroPrefix(vsPrefix);
      nf.setPosPrefix(vsPrefix);
    }
    if (ipPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON)
    {
      rf.setShowDecPoint(true);
    }
  }
  
  void adjustWidthAndPrecision(final PrintfState ipPs)
  {
    adjustWidth(ipPs);
    adjustPrecision(ipPs);
  }
  
  void adjustPrecision(final PrintfState ipPs)
  {
    if (mzVariablePrecision)
    {
      final RealFormatter vpRf = (RealFormatter) mpFormatter;
      final int vnRightDigits = ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue();
      vpRf.setMinRightDigits(vnRightDigits);
      vpRf.setMaxRightDigits(vnRightDigits);
    }
  }
  
  void formatFloat(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).floatValue()
      )
    );
  }

  void formatDouble(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).doubleValue()
      )
    );
  }
  
  void formatBigDecimal(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( (BigDecimal) ipPs.mapArgs[ipPs.mnArgIndex++]
      )
    );
  }
  
  void formatFloatScientific(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( MathToolbox.toScientificNotation
        ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).floatValue()
        )
      )
    );
  }
  
  void formatDoubleScientific(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( MathToolbox.toScientificNotation
        ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).doubleValue()
        )
      )
    );
  }
  
  void formatBigDecimalScientific(final PrintfState ipPs)
  {
    ipPs.mpOutput.append
    ( ( (RealFormatter) mpFormatter
      ).format
      ( MathToolbox.toScientificNotation
        ( (BigDecimal) ipPs.mapArgs[ipPs.mnArgIndex++]
        )
      )
    );
  }
  
}

