package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.IntegerFormatter;
import com.sharkysoft.printf.engine.RealFormatter;

class Formatter_e extends Formatter_Real
{

	Formatter_e(final FormatSpecifier ipPfs)
	{
		super(ipPfs);
		final IntegerFormatter ef = ((RealFormatter) mpFormatter).getExponentFormatter();
		switch (ipPfs.mcType)
		{
		case FormatSpecifier.TYPE_FLOAT_E_LOWER :
		case FormatSpecifier.TYPE_FLOAT_G_LOWER :
			ef.setNegPrefix("e-");
			ef.setZeroPrefix("e+");
			ef.setPosPrefix("e+");
			break;
		case FormatSpecifier.TYPE_FLOAT_E_UPPER :
		case FormatSpecifier.TYPE_FLOAT_G_UPPER :
			ef.setZeroPrefix("E+");
		}

	}

	void format(final PrintfState ipPs)
	{
		adjustWidthAndPrecision(ipPs);
		formatFloatScientific(ipPs);
	}

}

