package com.sharkysoft.printf;

import com.sharkysoft.math.MantissaExponent;
import com.sharkysoft.math.MathToolbox;
import com.sharkysoft.printf.engine.RealFormatter;

class Formatter_g extends Formatter_e
{

  Formatter_g(final FormatSpecifier ipPfs)
  {
    super(ipPfs);
    final RealFormatter vpRf = (RealFormatter) mpFormatter;
    if (ipPfs.mnPrecision == FormatSpecifier.PRECISION_UNSPECIFIED)
      vpRf.setSigDigits(6);
    else
      vpRf.setSigDigits(ipPfs.mnPrecision);
    vpRf.setMinRightDigits(0);
    vpRf.setMaxRightDigits(0);
  }
  
  protected final boolean shouldUseScientific(final MantissaExponent ipSnbd)
  {
    final int vnPrecision = ((RealFormatter) mpFormatter).getMaxRightDigits();
    final int vnExponent = ipSnbd.getExponent();
    return vnExponent > vnPrecision || vnExponent < -4;
  }
  
  protected void adjustPrecision(final PrintfState ipPs)
  {
    if (mzVariablePrecision)
    {
      final RealFormatter vpRf = (RealFormatter) mpFormatter;
      vpRf.setSigDigits(((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue());
    }
  }
  
  protected void adjustWidthAndPrecision(final PrintfState ipPs)
  {
    adjustWidth(ipPs);
    if (mzVariablePrecision)
      ( (RealFormatter) mpFormatter
      ).setMaxRightDigits
      ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex++]).intValue()
      );
  }
  
  void format(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    if 
    ( shouldUseScientific
      ( MathToolbox.toScientificNotation
        ( ((Number) ipPs.mapArgs[ipPs.mnArgIndex]).floatValue()
        )
      )
    )
      formatFloatScientific(ipPs);
    else
      formatFloat(ipPs);
  }
  
}

