package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.IntegerFormatter;
import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.util.UnreachableCodeException;

class Formatter_p extends Formatter_Integer
{

  Formatter_p(final FormatSpecifier ipPfs)
  {
    super(ipPfs);
    NumberFormatter nf = (NumberFormatter) mpFormatter;
    nf.setRadix(16);
    switch (ipPfs.mcType)
    {
    case 'p' :
      nf.setUpperCase(false);
      if (ipPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON)
      {
        nf.setZeroPrefix("0x");
        nf.setPosPrefix("0x");
      }
      break;
    case 'P' :
      nf.setUpperCase(true);
      if (ipPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON)
      {
        nf.setZeroPrefix("0X");
        nf.setPosPrefix("0X");
      }
      break;
    default :
      throw new UnreachableCodeException();
    }
  }

  void format(final PrintfState ipPs)
  {
    adjustWidthAndPrecision(ipPs);
    ipPs.mpOutput.append
    ( ((IntegerFormatter) mpFormatter).formatUnsigned
      ( System.identityHashCode(ipPs.mapArgs[ipPs.mnArgIndex++])
      )
    );
  }
  
}

